/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.jetbrains.annotations.NotNull;

public class SegmentPropertyState
extends Record
implements PropertyState {
    @NotNull
    private final SegmentReader reader;
    @NotNull
    private final String name;
    @NotNull
    private final Type<?> type;

    SegmentPropertyState(@NotNull SegmentReader reader, @NotNull RecordId id, @NotNull String name, @NotNull Type<?> type) {
        super(id);
        this.reader = Objects.requireNonNull(reader);
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
    }

    SegmentPropertyState(@NotNull SegmentReader reader, @NotNull RecordId id, @NotNull PropertyTemplate template) {
        this(reader, id, template.getName(), template.getType());
    }

    private ListRecord getValueList(Segment segment) {
        RecordId listId = this.getRecordId();
        int size = 1;
        if (this.isArray() && (size = segment.readInt(this.getRecordNumber())) > 0) {
            listId = segment.readRecordId(this.getRecordNumber(), 4);
        }
        return new ListRecord(listId, size);
    }

    Map<String, RecordId> getValueRecords() {
        if (this.getType().tag() == 2) {
            return Collections.emptyMap();
        }
        HashMap<String, RecordId> map = new HashMap<String, RecordId>();
        Segment segment = this.getSegment();
        ListRecord values = this.getValueList(segment);
        for (int i = 0; i < values.size(); ++i) {
            RecordId valueId = values.getEntry(i);
            String value = this.reader.readString(valueId);
            map.put(value, valueId);
        }
        return map;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Type<?> getType() {
        return this.type;
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int count() {
        if (this.isArray()) {
            return this.getSegment().readInt(this.getRecordNumber());
        }
        return 1;
    }

    @NotNull
    public <T> T getValue(Type<T> type) {
        Segment segment = this.getSegment();
        if (this.isArray()) {
            Validate.checkState((boolean)type.isArray());
            ListRecord values = this.getValueList(segment);
            if (values.size() == 0) {
                return (T)Collections.emptyList();
            }
            if (values.size() == 1) {
                return (T)Collections.singletonList(this.getValue(values.getEntry(0), type.getBaseType()));
            }
            Type base = type.getBaseType();
            ArrayList<T> list = new ArrayList<T>(values.size());
            for (RecordId id : values.getEntries()) {
                list.add(this.getValue(id, base));
            }
            return (T)list;
        }
        RecordId id = this.getRecordId();
        if (type.isArray()) {
            return (T)Collections.singletonList(this.getValue(id, type.getBaseType()));
        }
        return this.getValue(id, type);
    }

    public long size() {
        return this.size(0);
    }

    @NotNull
    public <T> T getValue(Type<T> type, int index) {
        Objects.requireNonNull(type);
        Validate.checkArgument((!type.isArray() ? 1 : 0) != 0, (String)"Type must not be an array type");
        Segment segment = this.getSegment();
        ListRecord values = this.getValueList(segment);
        Objects.checkIndex(index, values.size());
        return this.getValue(values.getEntry(index), type);
    }

    private <T> T getValue(RecordId id, Type<T> type) {
        if (type == Type.BINARY) {
            return (T)this.reader.readBlob(id);
        }
        String value = this.reader.readString(id);
        if (type == Type.STRING || type == Type.URI || type == Type.DATE || type == Type.NAME || type == Type.PATH || type == Type.REFERENCE || type == Type.WEAKREFERENCE) {
            return (T)value;
        }
        Type base = this.getType();
        if (base.isArray()) {
            base = base.getBaseType();
        }
        Conversions.Converter converter = Conversions.convert((String)value, (Type)base);
        if (type == Type.BOOLEAN) {
            return (T)Boolean.valueOf(converter.toBoolean());
        }
        if (type == Type.DECIMAL) {
            return (T)converter.toDecimal();
        }
        if (type == Type.DOUBLE) {
            return (T)Double.valueOf(converter.toDouble());
        }
        if (type == Type.LONG) {
            return (T)Long.valueOf(converter.toLong());
        }
        throw new UnsupportedOperationException("Unknown type: " + type);
    }

    public long size(int index) {
        ListRecord values = this.getValueList(this.getSegment());
        Objects.checkIndex(index, values.size());
        RecordId entry = values.getEntry(index);
        if (this.getType().equals((Object)Type.BINARY) || this.getType().equals((Object)Type.BINARIES)) {
            return this.reader.readBlob(entry).length();
        }
        return Segment.readLength(entry);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SegmentPropertyState) {
            SegmentPropertyState that = (SegmentPropertyState)object;
            if (!this.type.equals(that.type) || !this.name.equals(that.name)) {
                return false;
            }
            if (this.getRecordId().equals(that.getRecordId())) {
                return true;
            }
        }
        return object instanceof PropertyState && AbstractPropertyState.equal((PropertyState)this, (PropertyState)((PropertyState)object));
    }

    @Override
    public int hashCode() {
        return AbstractPropertyState.hashCode((PropertyState)this);
    }

    @Override
    public String toString() {
        return AbstractPropertyState.toString((PropertyState)this);
    }
}

