/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import edu.psu.swe.scim.server.configuration.ServerConfiguration;
import edu.psu.swe.scim.server.utility.EtagGenerator;
import edu.psu.swe.scim.spec.protocol.ServiceProviderConfigResource;
import edu.psu.swe.scim.spec.protocol.data.ErrorResponse;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.schema.Meta;
import edu.psu.swe.scim.spec.schema.ServiceProviderConfiguration;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Stateless
public class ServiceProviderConfigResourceImpl
implements ServiceProviderConfigResource {
    @Inject
    ServerConfiguration serverConfiguration = new ServerConfiguration();
    @Inject
    EtagGenerator etagGenerator;

    public void registerServerConfiguration(ServerConfiguration configuration) {
        this.serverConfiguration = configuration;
    }

    public Response getServiceProviderConfiguration(UriInfo uriInfo) {
        ServiceProviderConfiguration serviceProviderConfiguration = new ServiceProviderConfiguration();
        List<ServiceProviderConfiguration.AuthenticationSchema> authenticationSchemas = this.serverConfiguration.getAuthenticationSchemas();
        ServiceProviderConfiguration.BulkConfiguration bulk = this.serverConfiguration.getBulkConfiguration();
        ServiceProviderConfiguration.SupportedConfiguration changePassword = this.serverConfiguration.getChangePasswordConfiguration();
        ServiceProviderConfiguration.SupportedConfiguration etagConfig = this.serverConfiguration.getEtagConfiguration();
        ServiceProviderConfiguration.FilterConfiguration filter = this.serverConfiguration.getFilterConfiguration();
        ServiceProviderConfiguration.SupportedConfiguration patch = this.serverConfiguration.getPatchConfiguration();
        ServiceProviderConfiguration.SupportedConfiguration sort = this.serverConfiguration.getSortConfiguration();
        String documentationUrl = this.serverConfiguration.getDocumentationUri();
        String externalId = this.serverConfiguration.getId();
        String id = this.serverConfiguration.getId();
        Meta meta = new Meta();
        String location = uriInfo.getAbsolutePath().toString();
        String resourceType = "ServiceProviderConfig";
        LocalDateTime now = LocalDateTime.now();
        meta.setCreated(now);
        meta.setLastModified(now);
        meta.setLocation(location);
        meta.setResourceType(resourceType);
        serviceProviderConfiguration.setAuthenticationSchemes(authenticationSchemas);
        serviceProviderConfiguration.setBulk(bulk);
        serviceProviderConfiguration.setChangePassword(changePassword);
        serviceProviderConfiguration.setDocumentationUrl(documentationUrl);
        serviceProviderConfiguration.setEtag(etagConfig);
        serviceProviderConfiguration.setExternalId(externalId);
        serviceProviderConfiguration.setFilter(filter);
        serviceProviderConfiguration.setId(id);
        serviceProviderConfiguration.setMeta(meta);
        serviceProviderConfiguration.setPatch(patch);
        serviceProviderConfiguration.setSort(sort);
        try {
            EntityTag etag = this.etagGenerator.generateEtag((ScimResource)serviceProviderConfiguration);
            return Response.ok((Object)serviceProviderConfiguration).tag(etag).build();
        }
        catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e) {
            return this.createETagErrorResponse();
        }
    }

    private Response createETagErrorResponse() {
        ErrorResponse er = new ErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed to generate the etag");
        return er.toResponse();
    }
}

