/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.utils;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.im4java.utils.BaseFilter;

public class ExtensionFilter
extends BaseFilter {
    public static final ExtensionFilter STANDARD_IMAGES = new ExtensionFilter("jpg", "jpeg", "tif", "tiff", "png", "gif", "bmp");
    public static final ExtensionFilter RAW_IMAGES = new ExtensionFilter("3fr", "arw", "srf", "sr2", "bay", "crw", "cr2", "cap", "tif", "iiq", "eip", "dcs", "dcr", "drf", "k25", "kdc", "dng", "erf", "fff", "mef", "mos", "mrw", "nef", "nrw", "orf", "ptx", "pef", "pxn", "R3D", "raf", "raw", "rw2", "rwl", "rwz", "x3f");
    private HashSet<String> iExtensions = null;

    public ExtensionFilter(String ... stringArray) {
        this.iExtensions = new HashSet(stringArray.length);
        for (String string : stringArray) {
            this.iExtensions.add(string.toUpperCase(Locale.ENGLISH));
        }
    }

    public ExtensionFilter(Collection<String> collection) {
        this.iExtensions = new HashSet(collection.size());
        for (String string : collection) {
            this.iExtensions.add(string.toUpperCase(Locale.ENGLISH));
        }
    }

    @Override
    public boolean accept(File file, String string) {
        File file2 = new File(file.getPath() + File.separatorChar + string);
        if (file2.isDirectory()) {
            return this.acceptDir(file, string);
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1).toUpperCase(Locale.ENGLISH);
        return this.iExtensions.contains(string2);
    }
}

