/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.file.DiskFileItemFactoryProvider;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class FileUploadUtil {
    public static final String DEFAULT_ENCODING = Charsets.UTF_8.name();
    private static final ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactoryProvider().provide());

    private FileUploadUtil() {
    }

    public static boolean isRequestMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public static List<FileItem> parseRequest(HttpServletRequest request) {
        try {
            return upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new SilverpeasRuntimeException("Error uploading files", (Throwable)e);
        }
    }

    public static String getParameter(List<FileItem> items, String parameterName, String defaultValue, String encoding) {
        for (FileItem item : items) {
            if (!item.isFormField() || !parameterName.equals(item.getFieldName())) continue;
            try {
                return item.getString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                return item.getString();
            }
        }
        return defaultValue;
    }

    public static List<String> getParameterValues(List<FileItem> items, String parameterName, String encoding) {
        ArrayList<String> values = new ArrayList<String>();
        for (FileItem item : items) {
            if (!item.isFormField() || !item.getFieldName().startsWith(parameterName)) continue;
            try {
                values.add(item.getString(encoding));
            }
            catch (UnsupportedEncodingException e) {
                values.add(item.getString());
            }
        }
        return values;
    }

    public static String getParameter(List<FileItem> items, String parameterName, String defaultValue) {
        return FileUploadUtil.getParameter(items, parameterName, defaultValue, DEFAULT_ENCODING);
    }

    public static String getParameter(List<FileItem> items, String parameterName) {
        return FileUploadUtil.getParameter(items, parameterName, null);
    }

    public static String getOldParameter(List<FileItem> items, String parameterName) {
        return FileUploadUtil.getParameter(items, parameterName, null);
    }

    public static String getOldParameter(List<FileItem> items, String parameterName, String defaultValue) {
        return FileUploadUtil.getParameter(items, parameterName, defaultValue);
    }

    public static FileItem getFile(List<FileItem> items, String parameterName) {
        for (FileItem item : items) {
            if (item.isFormField() || !parameterName.equals(item.getFieldName())) continue;
            return item;
        }
        return null;
    }

    public static FileItem getFile(List<FileItem> items) {
        for (FileItem item : items) {
            if (item.isFormField()) continue;
            return item;
        }
        return null;
    }

    public static FileItem getFile(HttpServletRequest request) {
        List<FileItem> items = FileUploadUtil.parseRequest(request);
        return FileUploadUtil.getFile(items);
    }

    public static String getFileName(FileItem file) {
        if (file == null || !StringUtil.isDefined((String)file.getName())) {
            return "";
        }
        return FileUtil.getFilename(file.getName());
    }

    public static void saveToFile(File file, FileItem item) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)item.getInputStream(), (File)file);
    }
}

