/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.upload;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.kernel.logging.SilverLogger;

public class FileUploadManager {
    private static final String UPLOADED_FILE_PREFIX_ID = "uploaded-file";

    private FileUploadManager() {
        throw new IllegalStateException("Utility class");
    }

    public static List<UploadedFile> getUploadedFiles(HttpServletRequest request, User uploader) {
        Map parameters = null;
        if (request != null) {
            parameters = request.getParameterMap();
        }
        return FileUploadManager.getUploadedFiles(parameters, uploader);
    }

    public static List<UploadedFile> getUploadedFiles(Map<String, String[]> parameters, User uploader) {
        ArrayList<UploadedFile> uploadedFiles = new ArrayList<UploadedFile>();
        if (parameters != null) {
            parameters.forEach((name, value) -> {
                if (name.startsWith(UPLOADED_FILE_PREFIX_ID)) {
                    uploadedFiles.add(UploadedFile.from(parameters, value[0], uploader));
                }
            });
            uploadedFiles.remove(null);
            Iterator it = uploadedFiles.iterator();
            while (it.hasNext()) {
                UploadedFile uploadedFile = (UploadedFile)it.next();
                if (uploadedFile.getFile().exists()) continue;
                it.remove();
                SilverLogger.getLogger(FileUploadManager.class).warn("file does not exist (UploadSessionId={0}, FileName={1})", new Object[]{uploadedFile.getUploadSession().getId(), uploadedFile.getFile().getName()});
            }
        }
        return uploadedFiles;
    }
}

