/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.contentcontainer.content;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.ContentPeas;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentPostUpdate;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.JoinStatement;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class ContentManagementEngine
implements Serializable {
    private static final String INSTANCE_TABLE = "SB_ContentManager_Instance";
    private static final String SILVER_CONTENT_TABLE = "SB_ContentManager_Content";
    private static final String CONTENT = "content";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String WHERE_SILVER_CONTENT_ID_IS_SET = " WHERE silverContentId = ?";
    private final transient List<ContentPeas> acContentPeas = new ArrayList<ContentPeas>();
    private final Map<String, String> mapBetweenComponentIdAndInstanceId = new HashMap<String, String>();
    private final Map<String, String> mapBetweenSilverContentIdAndInternalComponentId = new HashMap<String, String>();

    private ContentManagementEngine() {
    }

    @PostConstruct
    private void loadContentPeas() {
        this.acContentPeas.add(new ContentPeas("whitePages"));
        this.acContentPeas.add(new ContentPeas("questionReply"));
        this.acContentPeas.add(new ContentPeas("kmelia"));
        this.acContentPeas.add(new ContentPeas("survey"));
        this.acContentPeas.add(new ContentPeas("toolbox"));
        this.acContentPeas.add(new ContentPeas("quickinfo"));
        this.acContentPeas.add(new ContentPeas("almanach"));
        this.acContentPeas.add(new ContentPeas("quizz"));
        this.acContentPeas.add(new ContentPeas("forums"));
        this.acContentPeas.add(new ContentPeas("pollingStation"));
        this.acContentPeas.add(new ContentPeas("bookmark"));
        this.acContentPeas.add(new ContentPeas("infoLetter"));
        this.acContentPeas.add(new ContentPeas("webSites"));
        this.acContentPeas.add(new ContentPeas("gallery"));
        this.acContentPeas.add(new ContentPeas("blog"));
        try {
            this.mapBetweenComponentIdAndInstanceId.putAll(this.loadMapping(null));
        }
        catch (ContentManagerException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public List<String> getResourcesMatchingContents(List<Integer> contentIds) {
        ArrayList<String> pks = new ArrayList<String>();
        for (Integer contentId : contentIds) {
            try {
                String id = this.getInternalContentId(contentId);
                pks.add(id);
            }
            catch (ContentManagerException contentManagerException) {}
        }
        return pks;
    }

    public int registerNewContentInstance(Connection connection, String sComponentId, String sContainerType, String sContentType) throws ContentManagerException {
        int n;
        boolean bCloseConnection = false;
        this.checkParameters(sComponentId, sContainerType, sContentType);
        PreparedStatement prepStmt = null;
        Connection theConnection = connection;
        try {
            if (theConnection == null) {
                theConnection = DBUtil.openConnection();
                bCloseConnection = true;
            }
            int newInstanceId = DBUtil.getNextId((String)INSTANCE_TABLE, (String)"instanceId");
            String sSQLStatement = "INSERT INTO SB_ContentManager_Instance(instanceId, componentId, containerType, contentType) VALUES (?, ?, ?, ?)";
            prepStmt = theConnection.prepareStatement(sSQLStatement);
            prepStmt.setInt(1, newInstanceId);
            prepStmt.setString(2, sComponentId);
            prepStmt.setString(3, sContainerType);
            prepStmt.setString(4, sContentType);
            prepStmt.executeUpdate();
            this.addMapping(sComponentId, newInstanceId);
            n = newInstanceId;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("Cannot register content instance for component " + sComponentId + "  and with content type " + sContentType, e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (bCloseConnection) {
                    this.closeConnection(theConnection);
                }
                throw throwable;
            }
        }
        DBUtil.close((Statement)prepStmt);
        if (bCloseConnection) {
            this.closeConnection(theConnection);
        }
        return n;
    }

    private void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    public void unregisterNewContentInstance(Connection connection, String sComponentId, String sContainerType, String sContentType) throws ContentManagerException {
        boolean bCloseConnection = false;
        this.checkParameters(sComponentId, sContainerType, sContentType);
        Connection theConnection = connection;
        try {
            if (theConnection == null) {
                theConnection = DBUtil.openConnection();
                bCloseConnection = true;
            }
            String contentDeletion = "DELETE FROM SB_ContentManager_Content WHERE contentInstanceId IN (SELECT instanceId from SB_ContentManager_Instance WHERE componentId = ? AND containerType = ? AND contentType = ?)";
            String instanceDeletion = "DELETE FROM SB_ContentManager_Instance WHERE componentId = ? AND containerType = ? AND contentType = ?";
            try (PreparedStatement deletion = theConnection.prepareStatement("DELETE FROM SB_ContentManager_Content WHERE contentInstanceId IN (SELECT instanceId from SB_ContentManager_Instance WHERE componentId = ? AND containerType = ? AND contentType = ?)");){
                this.deleteMappingInDS(deletion, sComponentId, sContainerType, sContentType);
            }
            deletion = theConnection.prepareStatement("DELETE FROM SB_ContentManager_Instance WHERE componentId = ? AND containerType = ? AND contentType = ?");
            try {
                this.deleteMappingInDS(deletion, sComponentId, sContainerType, sContentType);
            }
            finally {
                if (deletion != null) {
                    deletion.close();
                }
            }
            this.removeMapping(sComponentId);
        }
        catch (Exception e) {
            throw new ContentManagerException("Cannot unregister content instance for component " + sComponentId + " and with content type " + sContentType, e);
        }
        finally {
            if (bCloseConnection) {
                this.closeConnection(theConnection);
            }
        }
    }

    public ContentPeas getContentPeas(String sComponentId) {
        return this.getContentPeasByComponentName(SilverpeasComponentInstance.getComponentName((String)sComponentId));
    }

    public ContentPeas getContentPeasByComponentName(String componentName) {
        for (ContentPeas s_acContentPea : this.acContentPeas) {
            if (!s_acContentPea.getType().equals(componentName)) continue;
            return s_acContentPea;
        }
        return null;
    }

    public int addSilverContent(Connection connection, String sInternalContentId, String sComponentId, String sAuthorId, SilverContentVisibility scv) throws ContentManagerException {
        int n;
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Date systemDate = new Date(time);
        boolean bCloseConnection = false;
        SilverContentVisibility visibility = scv;
        if (visibility == null) {
            visibility = new SilverContentVisibility();
        }
        PreparedStatement prepStmt = null;
        Connection conn = connection;
        try {
            if (conn == null) {
                conn = DBUtil.openConnection();
                bCloseConnection = true;
            }
            int nContentInstanceId = this.getContentInstanceId(sComponentId);
            int newSilverContentId = DBUtil.getNextId((String)SILVER_CONTENT_TABLE, (String)"silverContentId");
            String sSQLStatement = "INSERT INTO SB_ContentManager_Content(silverContentId, internalContentId, contentInstanceid, authorId, creationDate, beginDate, endDate, isVisible) VALUES (?, ?, ?, ?, ?, ? , ? , ? )";
            prepStmt = conn.prepareStatement(sSQLStatement);
            prepStmt.setInt(1, newSilverContentId);
            prepStmt.setString(2, sInternalContentId);
            prepStmt.setInt(3, nContentInstanceId);
            prepStmt.setInt(4, Integer.parseInt(sAuthorId));
            prepStmt.setDate(5, systemDate);
            prepStmt.setString(6, visibility.getBeginDate());
            prepStmt.setString(7, visibility.getEndDate());
            prepStmt.setInt(8, visibility.isVisible());
            prepStmt.executeUpdate();
            n = newSilverContentId;
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException(SilverpeasExceptionMessages.failureOnAdding((String)CONTENT, (Object)sInternalContentId), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                if (bCloseConnection) {
                    this.closeConnection(conn);
                }
                throw throwable;
            }
        }
        DBUtil.close((Statement)prepStmt);
        if (bCloseConnection) {
            this.closeConnection(conn);
        }
        return n;
    }

    public void removeSilverContent(Connection connection, int nSilverContentId) throws ContentManagerException {
        PreparedStatement prepStmt = null;
        try {
            String sSQLStatement = "DELETE FROM SB_ContentManager_Content WHERE silverContentId = ?";
            prepStmt = connection.prepareStatement(sSQLStatement);
            prepStmt.setInt(1, nSilverContentId);
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException(SilverpeasExceptionMessages.failureOnDeleting((String)CONTENT, (Object)nSilverContentId), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(prepStmt);
                throw throwable;
            }
        }
        DBUtil.close((Statement)prepStmt);
    }

    private int getSilverContentId(Connection connection, String sInternalContentId, String sComponentId, boolean isGlobalSearch) throws ContentManagerException {
        int iComponentId;
        int nSilverContentId = -1;
        Object sSQLStatement = "SELECT silverContentId FROM SB_ContentManager_Content WHERE internalContentId = ? AND contentInstanceId = ";
        if (isGlobalSearch) {
            sSQLStatement = (String)sSQLStatement + "(select instanceId from SB_ContentManager_Instance where componentId = ?)";
            iComponentId = -1;
        } else {
            sSQLStatement = (String)sSQLStatement + "?";
            iComponentId = this.getContentInstanceId(sComponentId);
        }
        try (PreparedStatement stmt = connection.prepareStatement((String)sSQLStatement);){
            stmt.setString(1, sInternalContentId);
            if (isGlobalSearch) {
                stmt.setString(2, sComponentId);
            } else {
                stmt.setInt(2, iComponentId);
            }
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    nSilverContentId = rs.getInt(1);
                }
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return nSilverContentId;
    }

    public int getSilverContentId(String sInternalContentId, String sComponentId) throws ContentManagerException {
        int n;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                n = this.getSilverContentId(connection, sInternalContentId, sComponentId, false);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ContentManagerException(SilverpeasExceptionMessages.failureOnGetting((String)CONTENT, (Object)sInternalContentId), e);
                }
            }
            connection.close();
        }
        return n;
    }

    public SortedSet<Integer> getSilverContentId(List<String> documentFeature) throws ContentManagerException {
        TreeSet<Integer> treeSet;
        block9: {
            TreeSet<Integer> alSilverContentId = new TreeSet<Integer>();
            String sInternalContentId = "";
            String sComponentId = "";
            Connection connection = DBUtil.openConnection();
            try {
                for (int i = 0; i < documentFeature.size(); i += 2) {
                    sInternalContentId = documentFeature.get(i);
                    int silverContentId = this.getSilverContentId(connection, sInternalContentId, sComponentId = documentFeature.get(i + 1), true);
                    if (silverContentId == -1) continue;
                    alSilverContentId.add(silverContentId);
                }
                treeSet = alSilverContentId;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ContentManagerException(SilverpeasExceptionMessages.failureOnGetting((String)CONTENT, (Object)sInternalContentId), e);
                }
            }
            connection.close();
        }
        return treeSet;
    }

    private String getInternalContentIdFromCache(String sSilverContentId) {
        return this.mapBetweenSilverContentIdAndInternalComponentId.get(sSilverContentId);
    }

    private void putInternalContentIdIntoCache(String sSilverContentId, String sInternalContentId) {
        this.mapBetweenSilverContentIdAndInternalComponentId.put(sSilverContentId, sInternalContentId);
    }

    public String getInternalContentId(int nSilverContentId) throws ContentManagerException {
        String sSilverContentId = String.valueOf(nSilverContentId);
        String sInternalContentId = this.getInternalContentIdFromCache(sSilverContentId);
        if (sInternalContentId == null) {
            Connection connection = null;
            PreparedStatement prepStmt = null;
            ResultSet resSet = null;
            try {
                connection = DBUtil.openConnection();
                String sSQLStatement = "SELECT internalContentId FROM SB_ContentManager_Content WHERE silverContentId = ?";
                prepStmt = connection.prepareStatement(sSQLStatement);
                prepStmt.setInt(1, nSilverContentId);
                resSet = prepStmt.executeQuery();
                if (resSet.next()) {
                    sInternalContentId = resSet.getString(1);
                }
                this.putInternalContentIdIntoCache(sSilverContentId, sInternalContentId);
            }
            catch (Exception e) {
                try {
                    throw new ContentManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"internal content id", (Object)nSilverContentId), e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(resSet, prepStmt);
                    this.closeConnection(connection);
                    throw throwable;
                }
            }
            DBUtil.close((ResultSet)resSet, (Statement)prepStmt);
            this.closeConnection(connection);
        }
        return sInternalContentId;
    }

    public int getContentInstanceId(String sComponentId) throws ContentManagerException {
        int contentInstanceId = -1;
        String sContentInstanceId = this.getInstanceId(sComponentId);
        if (sContentInstanceId != null) {
            contentInstanceId = Integer.parseInt(sContentInstanceId);
        } else {
            String componentName = this.extractComponentNameFromInstanceId(sComponentId);
            contentInstanceId = this.registerNewContentInstance(null, sComponentId, "containerPDC", componentName);
        }
        return contentInstanceId;
    }

    public JoinStatement getPositionsByGenericSearch(String authorId, String afterDate, String beforeDate) {
        StringBuilder sSQLStatement = new StringBuilder(1000);
        JoinStatement joinStatement = new JoinStatement();
        ArrayList<String> alGivenTables = new ArrayList<String>();
        ArrayList<String> alGivenKeys = new ArrayList<String>();
        alGivenTables.add(SILVER_CONTENT_TABLE);
        alGivenKeys.add("silverContentId");
        joinStatement.setTables(alGivenTables);
        joinStatement.setJoinKeys(alGivenKeys);
        if (authorId != null && !"".equals(authorId)) {
            sSQLStatement.append(" CMC.authorId = ").append(authorId);
        }
        if (beforeDate != null && beforeDate.length() > 0) {
            if (sSQLStatement.length() > 0) {
                sSQLStatement.append(" AND ");
            }
            sSQLStatement.append(" CMC.creationDate < ? ");
        }
        if (afterDate != null && afterDate.length() > 0) {
            if (sSQLStatement.length() > 0) {
                sSQLStatement.append(" AND ");
            }
            sSQLStatement.append(" CMC.creationDate > ? ");
        }
        joinStatement.setWhere(sSQLStatement.toString());
        return joinStatement;
    }

    public List<ResourceReference> getResourceReferencesByContentIds(List<Integer> alSilverContentId) throws ContentManagerException {
        try {
            ArrayList<ResourceReference> result = new ArrayList<ResourceReference>();
            JdbcSqlQuery.executeBySplittingOn(alSilverContentId, (idBatch, ignore) -> JdbcSqlQuery.select((String)"C.internalcontentid, I.componentId ").from(new String[]{"SB_ContentManager_Instance I"}).join("SB_ContentManager_Content C").on("I.instanceId = C.contentInstanceId", new Object[0]).where("C.silverContentId", new Object[0]).in(idBatch).execute(r -> {
                ResourceReference ref = new ResourceReference(r.getString(1), r.getString(2));
                result.add(ref);
                return null;
            }));
            return result;
        }
        catch (Exception e) {
            throw new ContentManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"instance id for content", alSilverContentId), e);
        }
    }

    /*
     * Exception decompiling
     */
    public List<Integer> getSilverContentIdByInstanceId(String instanceId) throws ContentManagerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateSilverContentVisibilityAttributes(SilverContentVisibility scv, int silverObjectId) throws ContentManagerException {
        if (scv != null) {
            String sSQLStatement = "UPDATE SB_ContentManager_Content SET beginDate = ? , endDate = ? , isVisible = ?  WHERE silverContentId = ?";
            try (Connection con = DBUtil.openConnection();
                 PreparedStatement prepStmt = con.prepareStatement(sSQLStatement);){
                prepStmt.setString(1, scv.getBeginDate());
                prepStmt.setString(2, scv.getEndDate());
                prepStmt.setInt(3, scv.isVisible());
                prepStmt.setInt(4, silverObjectId);
                prepStmt.executeUpdate();
            }
            catch (Exception e) {
                throw new ContentManagerException(SilverpeasExceptionMessages.failureOnUpdate((String)"silverpeas content", (Object)silverObjectId), e);
            }
            ServiceProvider.getAllServices(SilverContentPostUpdate.class, (Annotation[])new Annotation[0]).forEach(c -> c.postSilverpeasContentUpdate(silverObjectId));
        }
    }

    public SilverContentVisibility getSilverContentVisibility(int silverObjectId) throws ContentManagerException {
        SilverContentVisibility scv;
        String sSQLStatement = "SELECT beginDate, endDate, isVisible FROM SB_ContentManager_Content WHERE silverContentId = ?";
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement prepStmt = connection.prepareStatement(sSQLStatement);){
            prepStmt.setInt(1, silverObjectId);
            try (ResultSet resSet = prepStmt.executeQuery();){
                if (resSet.next()) {
                    String beginDate = resSet.getString(1);
                    String endDate = resSet.getString(2);
                    int visibility = resSet.getInt(3);
                    boolean isVisible = visibility != 0;
                    scv = new SilverContentVisibility(beginDate, endDate, isVisible);
                } else {
                    scv = null;
                }
            }
        }
        catch (SQLException e) {
            throw new ContentManagerException(SilverpeasExceptionMessages.failureOnGetting((String)"visibility of silverpeas content", (Object)silverObjectId), e);
        }
        return scv;
    }

    private String extractComponentNameFromInstanceId(String instanceId) {
        for (int i = 0; i < instanceId.length(); ++i) {
            char character = instanceId.charAt(i);
            if (character != '0' && character != '1' && character != '2' && character != '3' && character != '4' && character != '5' && character != '6' && character != '7' && character != '8' && character != '9') continue;
            return instanceId.substring(0, i);
        }
        return instanceId;
    }

    private Map<String, String> getMapping() {
        return this.mapBetweenComponentIdAndInstanceId;
    }

    private String getInstanceId(String componentId) {
        return this.getMapping().get(componentId);
    }

    private void addMapping(String componentId, int instanceId) {
        this.getMapping().put(componentId, Integer.toString(instanceId));
    }

    private void removeMapping(String componentId) {
        this.getMapping().remove(componentId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> loadMapping(Connection connection) throws ContentManagerException {
        boolean bCloseConnection = false;
        PreparedStatement prepStmt = null;
        ResultSet resSet = null;
        HashMap<String, String> tempAsso = new HashMap<String, String>();
        Connection conn = connection;
        try {
            if (conn == null) {
                conn = DBUtil.openConnection();
                bCloseConnection = true;
            }
            String sSQLStatement = "SELECT instanceId, componentId FROM SB_ContentManager_Instance";
            prepStmt = conn.prepareStatement(sSQLStatement);
            resSet = prepStmt.executeQuery();
            while (resSet.next()) {
                tempAsso.put(resSet.getString(2), String.valueOf(resSet.getInt(1)));
            }
        }
        catch (Exception e) {
            try {
                throw new ContentManagerException("Cannot load content mapping cache", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resSet, prepStmt);
                try {
                    if (!bCloseConnection) throw throwable;
                    DBUtil.close((Connection)conn);
                    throw throwable;
                }
                catch (Exception e2) {
                    SilverLogger.getLogger((Object)this).error(e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resSet, (Statement)prepStmt);
        try {
            if (!bCloseConnection) return tempAsso;
            DBUtil.close((Connection)conn);
            return tempAsso;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return tempAsso;
        }
    }

    private void deleteMappingInDS(PreparedStatement deletion, String ... parameters) throws SQLException {
        for (int i = 0; i < parameters.length; ++i) {
            deletion.setString(i + 1, parameters[i]);
        }
        deletion.execute();
    }

    private void checkParameters(String sComponentId, String sContainerType, String sContentType) throws ContentManagerException {
        if (StringUtil.isNotDefined((String)sComponentId)) {
            throw new ContentManagerException("The component instance id should be defined", new String[0]);
        }
        if (StringUtil.isNotDefined((String)sContainerType)) {
            throw new ContentManagerException("The type of the content container should be defined", new String[0]);
        }
        if (StringUtil.isNotDefined((String)sContentType)) {
            throw new ContentManagerException("The content type should be defined", new String[0]);
        }
    }
}

