/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Printable;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.displayers.AbstractTextFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.TextField;
import org.silverpeas.core.contribution.content.form.field.TextFieldImpl;

public class TextFieldDisplayer
extends AbstractTextFieldDisplayer {
    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        if (field == null) {
            return;
        }
        AbstractTextFieldDisplayer.FieldProperties fieldProps = this.getFieldProperties(template, field, pageContext);
        String fieldName = fieldProps.getFieldName();
        String paramSuggestions = fieldProps.getParameters().getOrDefault("suggestions", "false");
        boolean useSuggestions = Boolean.parseBoolean(paramSuggestions);
        List<String> suggestions = TextFieldDisplayer.useSuggestions((TextFieldImpl)field, template, pageContext, fieldName, useSuggestions);
        String cssClass = TextFieldDisplayer.getCssClass(fieldProps.getParameters());
        input textInput = TextFieldDisplayer.makeTextInput(fieldProps, cssClass);
        img image = TextFieldDisplayer.getMandatoryIcon(template, pageContext);
        if (suggestions != null && !suggestions.isEmpty()) {
            TextFieldImpl.printSuggestionsIncludes(fieldName, out);
            out.println("<div id=\"listAutocomplete" + fieldName + "\">\n");
            out.println(textInput);
            out.println("<div id=\"container" + fieldName + "\"/>\n");
            out.println("</div>\n");
            if (image != null) {
                out.println(image);
            }
            TextFieldImpl.printSuggestionsScripts(fieldName, suggestions, out);
        } else {
            Printable elt = this.setImage(textInput, image);
            out.println(elt);
        }
    }

    private static String getCssClass(Map<String, String> parameters) {
        Object cssClass = null;
        if (parameters.containsKey("class") && (cssClass = parameters.get("class")) != null) {
            cssClass = "class=\"" + (String)cssClass + "\"";
        }
        return cssClass;
    }

    private static List<String> useSuggestions(TextFieldImpl field, FieldTemplate template, PagesContext pageContext, String fieldName, boolean useSuggestions) {
        List<String> suggestions = null;
        if (useSuggestions) {
            suggestions = field.getSuggestions(fieldName, template.getTemplateName(), pageContext.getComponentId());
        }
        return suggestions;
    }
}

