/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.dao;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.user.constant.GroupState;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ArrayUtil;

public class SqlUserSelectorByCriteriaBuilder {
    private final String fields;

    SqlUserSelectorByCriteriaBuilder(String fields) {
        this.fields = fields;
    }

    public JdbcSqlQuery build(UserDetailsSearchCriteria criteria) {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)this.fields);
        this.applyJoinsAndDefaultCriteria(query, criteria);
        this.applyCriteriaOnRoles(query, criteria);
        this.applyCriteriaOnDomain(query, criteria);
        this.applyCriteriaOnUserIds(query, criteria);
        this.applyCriteriaOnAccessLevel(query, criteria);
        this.applyCriteriaOnUserName(query, criteria);
        this.applyCriteriaOnGroupIds(query, criteria);
        if (!this.fields.toLowerCase().matches("(count|max|min)\\(.*\\)")) {
            query.orderBy(new String[]{"lastName, firstName"});
            if (criteria.isCriterionOnPaginationSet()) {
                query.withPagination(criteria.getCriterionOnPagination().asCriterion());
            }
        }
        return query;
    }

    private void applyJoinsAndDefaultCriteria(JdbcSqlQuery query, UserDetailsSearchCriteria criteria) {
        query.from(new String[]{"st_user"});
        if (criteria.isCriterionOnGroupIdsSet() || criteria.isCriterionOnAnyGroupSet()) {
            query.join("st_group_user_rel").on("st_group_user_rel.userid = st_user.id", new Object[0]);
            query.join("st_group").on("st_group.id = st_group_user_rel.groupid", new Object[0]);
        }
        query.where("st_user.state", new Object[0]).notIn(this.getExcludedUserStates(criteria));
    }

    private void applyCriteriaOnGroupIds(JdbcSqlQuery query, UserDetailsSearchCriteria criteria) {
        if (criteria.isCriterionOnGroupIdsSet() || criteria.isCriterionOnAnyGroupSet()) {
            query.and("st_group.state", new Object[0]).notIn(new Object[]{GroupState.REMOVED});
            Object[] groupIds = criteria.getCriterionOnGroupIds();
            if (ArrayUtil.isNotEmpty(groupIds)) {
                query.and("st_group_user_rel.groupId", new Object[0]).in((Collection)Stream.of(groupIds).map(Integer::parseInt).collect(Collectors.toList()));
            }
        }
    }

    private void applyCriteriaOnUserName(JdbcSqlQuery query, UserDetailsSearchCriteria criteria) {
        if (criteria.isCriterionOnNameSet()) {
            String normalizedName = criteria.getCriterionOnName().replace('*', '%');
            query.and("(lower(st_user.firstName) like lower(?) OR lower(st_user.lastName) like lower(?))", new Object[]{normalizedName, normalizedName});
        } else {
            String normalizedName;
            if (criteria.isCriterionOnFirstNameSet()) {
                normalizedName = criteria.getCriterionOnFirstName().replace('*', '%');
                query.and("lower(st_user.firstName) like lower(?)", new Object[]{normalizedName});
            }
            if (criteria.isCriterionOnLastNameSet()) {
                normalizedName = criteria.getCriterionOnLastName().replace('*', '%');
                query.and("lower(st_user.lastName) like lower(?)", new Object[]{normalizedName});
            }
        }
    }

    private void applyCriteriaOnAccessLevel(JdbcSqlQuery query, UserDetailsSearchCriteria criteria) {
        if (criteria.isCriterionOnAccessLevelsSet()) {
            List codes = Stream.of(criteria.getCriterionOnAccessLevels()).map(UserAccessLevel::getCode).collect(Collectors.toList());
            query.and("st_user.accessLevel", new Object[0]).in(codes);
        }
    }

    private void applyCriteriaOnUserIds(JdbcSqlQuery query, UserDetailsSearchCriteria criteria) {
        if (criteria.isCriterionOnUserIdsSet()) {
            String[] userIds = criteria.getCriterionOnUserIds();
            query.and("st_user.id", new Object[0]).in((Collection)Stream.of(userIds).map(Integer::parseInt).collect(Collectors.toList()));
        }
        if (criteria.isCriterionOnUserSpecificIdsSet()) {
            query.and("st_user.specificId", new Object[0]).in((Object[])criteria.getCriterionOnUserSpecificIds());
        }
    }

    private void applyCriteriaOnDomain(JdbcSqlQuery query, UserDetailsSearchCriteria criteria) {
        if (criteria.isCriterionOnDomainIdSet()) {
            String[] domainIds = criteria.getCriterionOnDomainIds();
            if (domainIds.length > 1 && criteria.isCriterionOnUserSpecificIdsSet()) {
                throw new IllegalArgumentException("Criterion on user specific id whereas there is a criterion on several user domains");
            }
            query.and("st_user.domainId", new Object[0]).in((Collection)Stream.of(domainIds).map(Integer::parseInt).collect(Collectors.toList()));
        }
    }

    private void applyCriteriaOnRoles(JdbcSqlQuery query, UserDetailsSearchCriteria criteria) {
        criteria.getNonPublicSharedComponentInstance().ifPresent(i -> {
            int instanceId = ComponentInst.getComponentLocalId(i.getId());
            query.and("st_user.id IN (", new Object[0]);
            query.addSqlPart("SELECT distinct all_profiles.userid FROM (SELECT distinct urur.userId, ur.rolename FROM st_userrole_user_rel urur INNER JOIN st_userrole ur ON urur.userroleId = ur.id WHERE ur.instanceId = ?", new Object[]{instanceId});
            if (criteria.isCriterionOnResourceIdSet()) {
                List profiledResourceId = Stream.of(criteria.getCriterionOnResourceId()).map(ProfiledObjectId::from).collect(Collectors.toList());
                query.and("ur.objecttype", new Object[0]).in((Collection)profiledResourceId.stream().map(ProfiledObjectId::getType).map(ProfiledObjectType::getCode).collect(Collectors.toList()));
                query.and("ur.objectId", new Object[0]).in((Collection)profiledResourceId.stream().map(ProfiledObjectId::getId).map(Integer::parseInt).collect(Collectors.toList()));
            } else {
                query.andNull("ur.objectId");
            }
            if (criteria.isCriterionOnRoleNamesSet()) {
                query.and("ur.rolename", new Object[0]).in((Object[])criteria.getCriterionOnRoleNames());
            }
            if (criteria.isCriterionOnGroupsByRolesSet()) {
                Map<String, Set<String>> groupIdsByRoles = criteria.getCriterionOnGroupsByRoles();
                if (criteria.mustMatchAllRoles()) {
                    groupIdsByRoles.forEach((r, g) -> {
                        query.union();
                        query.addSqlPart(MessageFormat.format("SELECT distinct gur.userId, ''{0}'' as rolename FROM st_group_user_rel gur WHERE gur.groupId", r), new Object[0]).in((Collection)g.stream().map(Integer::parseInt).collect(Collectors.toList()));
                    });
                } else {
                    query.union();
                    query.addSqlPart("SELECT distinct gur.userId, 'dummy' as rolename FROM st_group_user_rel gur WHERE gur.groupId", new Object[0]).in((Collection)groupIdsByRoles.values().stream().flatMap(Collection::stream).distinct().map(Integer::parseInt).collect(Collectors.toList()));
                }
            }
            query.addSqlPart(") all_profiles", new Object[0]);
            if (criteria.mustMatchAllRoles()) {
                query.addSqlPart("GROUP BY all_profiles.userid HAVING COUNT(all_profiles.userid) = ?", new Object[]{criteria.getCriterionOnRoleNames().length});
            }
            query.addSqlPart(")", new Object[0]);
        });
    }

    private Set<UserState> getExcludedUserStates(UserDetailsSearchCriteria criteria) {
        HashSet<UserState> excludedStates = new HashSet<UserState>();
        excludedStates.add(UserState.DELETED);
        if (criteria.isCriterionOnUserStatesToExcludeSet()) {
            excludedStates.addAll(Arrays.asList(criteria.getCriterionOnUserStatesToExclude()));
        }
        if (!criteria.mustIncludeRemovedUsers()) {
            criteria.getNonPublicSharedComponentInstance().ifPresent(i -> excludedStates.add(UserState.REMOVED));
        }
        return excludedStates;
    }
}

