/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.time.LocalDate;
import java.util.Date;
import org.silverpeas.core.admin.AdminSettings;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.SchedulingInitializer;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class DeleteRemovedUsersScheduler
extends SchedulingInitializer {
    protected static final String JOB_NAME = "DeleteRemovedUsersJob";
    private final Job job = new DeleteRemovedUsersJob();

    @NonNull
    protected String getCron() {
        return AdminSettings.getDeletionOfRemovedUsersCron();
    }

    @NonNull
    protected Job getJob() {
        return this.job;
    }

    protected boolean isSchedulingEnabled() {
        return AdminSettings.isAutomaticDeletionOfRemovedUsersEnabled();
    }

    private static class DeleteRemovedUsersJob
    extends Job {
        DeleteRemovedUsersJob() {
            super(DeleteRemovedUsersScheduler.JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            if (AdminSettings.isAutomaticDeletionOfRemovedUsersEnabled()) {
                Administration administration = Administration.get();
                for (Domain domain : OrganizationControllerProvider.getOrganisationController().getAllDomains()) {
                    try {
                        for (User user : administration.getRemovedUsers(domain.getId())) {
                            LocalDate now;
                            LocalDate stateSaveDayDateWithDelay = DateUtil.toLocalDate((Date)user.getStateSaveDate()).plusDays(AdminSettings.getDeletionOfRemovedUsersDayDelay());
                            if (!stateSaveDayDateWithDelay.isBefore(now = LocalDate.now()) && !stateSaveDayDateWithDelay.isEqual(now)) continue;
                            administration.deleteUser(user.getId());
                        }
                    }
                    catch (Exception e) {
                        SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

