/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.CommunityMembersGroup;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceProfileInst;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class CommunityMembershipService {
    @Inject
    private Administration admin;

    public static CommunityMembershipService get() {
        return (CommunityMembershipService)ServiceProvider.getService(CommunityMembershipService.class, (Annotation[])new Annotation[0]);
    }

    public SpaceInst getCommunity(String spaceId) throws AdminException {
        SpaceInst space = this.admin.getSpaceInstById(spaceId);
        if (space == null || !space.isCommunitySpace()) {
            throw new AdminException("No community space found with id " + spaceId, new String[0]);
        }
        return space;
    }

    public CommunityMembersGroup getGroup(String groupId) throws AdminException {
        return this.asAppManagedGroupDetail(this.admin.getGroup(groupId));
    }

    public void updateGroup(CommunityMembersGroup group) throws AdminException {
        this.admin.updateGroup(group, true);
    }

    public void addMember(User user, CommunityMembersGroup group, SilverpeasRole role) throws AdminException {
        SpaceInst space;
        User currentUser = User.getCurrentRequester();
        SpaceProfileInst profile = this.getSpaceProfile(currentUser, role, space = this.admin.getSpaceInstById(group.getSpaceId()));
        if (!this.isUserHasProfile(user, profile)) {
            profile.addUser(user.getId());
            this.admin.updateSpaceProfileInst(profile, currentUser.getId());
        }
        if (!this.isUserInGroup(user, group)) {
            this.admin.addUserInGroup(user.getId(), group.getId());
        }
    }

    public void removeMember(User user, CommunityMembersGroup group) throws AdminException {
        SpaceInst space = this.admin.getSpaceInstById(group.getSpaceId());
        this.removeUserFromAllSpaceProfiles(user, space);
        if (this.isUserInGroup(user, group)) {
            this.admin.removeUserFromGroup(user.getId(), group.getId());
        }
    }

    public CommunityMembersGroup setUpCommunity(String spaceId, String symbol) throws AdminException {
        User currentUser = User.getCurrentRequester();
        SpaceInst space = this.getCommunity(spaceId);
        CommunityMembersGroup group = new CommunityMembersGroup(symbol + " " + space.getName(), spaceId);
        String groupId = this.admin.addGroup(group, true);
        SpaceProfileInst profile = this.getSpaceProfile(currentUser, SilverpeasRole.READER, space);
        profile.addGroup(groupId);
        this.admin.updateSpaceProfileInst(profile, currentUser.getId());
        return this.asAppManagedGroupDetail(this.admin.getGroup(groupId));
    }

    public void deleteCommunity(String spaceId, String groupId) throws AdminException {
        GroupDetail group;
        SpaceInst space;
        if (spaceId != null && (space = this.admin.getSpaceInstById(spaceId)) != null) {
            space.setCommunitySpace(false);
            this.admin.updateSpaceInst(space);
        }
        if (groupId != null && (group = this.admin.getGroup(groupId)) != null && group.isCommunityGroup()) {
            this.admin.deleteGroupById(group.getId(), true);
        }
    }

    private void removeUserFromAllSpaceProfiles(User user, SpaceInst space) {
        User currentUser = User.getCurrentRequester();
        this.streamOnNonInheritedSpaceProfiles(space).filter(p -> this.isUserHasProfile(user, (SpaceProfileInst)p)).forEach(p -> {
            try {
                p.removeUser(user.getId());
                this.admin.updateSpaceProfileInst((SpaceProfileInst)p, currentUser.getId());
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        });
    }

    private Stream<SpaceProfileInst> streamOnNonInheritedSpaceProfiles(SpaceInst space) {
        return space.getAllSpaceProfilesInst().stream().filter(Predicate.not(SpaceProfileInst::isManager).and(Predicate.not(BaseRightProfile::isInherited)));
    }

    private CommunityMembersGroup asAppManagedGroupDetail(GroupDetail groupDetail) {
        return groupDetail == null ? null : new CommunityMembersGroup(groupDetail);
    }

    private SpaceProfileInst getSpaceProfile(User invoker, SilverpeasRole role, SpaceInst space) throws AdminException {
        SpaceProfileInst profile = space.getDirectSpaceProfileInst(role.getName());
        if (profile == null) {
            profile = new SpaceProfileInst();
            profile.setName(role.getName());
            profile.setSpaceFatherId(space.getId());
            profile.setInherited(false);
            this.admin.addSpaceProfileInst(profile, invoker.getId());
            space.addSpaceProfileInst(profile);
        }
        return profile;
    }

    private boolean isUserHasProfile(User user, SpaceProfileInst profile) {
        return profile.getAllUsers().contains(user.getId());
    }

    private boolean isUserInGroup(User user, GroupDetail group) {
        return List.of(group.getUserIds()).contains(user.getId());
    }
}

