/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.admin.persistence.ComponentInstanceRow;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.admin.persistence.UserRoleRow;
import org.silverpeas.core.admin.persistence.UserRoleTable;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Repository
public class ComponentInstanceTable
extends Table<ComponentInstanceRow> {
    private static final String INSTANCE_COLUMNS = "id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked";
    private static final String SELECT = "select ";
    private static final String SELECT_INSTANCE_BY_ID = "select id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked from ST_ComponentInstance where id = ?";
    private static final String DELETE_INSTANCE = "delete from ST_ComponentInstance where id = ?";
    private static final String SELECT_ALL_SPACE_INSTANCES = "select id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked from ST_ComponentInstance where spaceId = ? and componentStatus is null order by orderNum";
    private static final String SELECT_ALL_SPACE_INSTANCE_IDS = "select id from ST_ComponentInstance where spaceId = ? and componentStatus is null order by orderNum";
    private static final String SELECT_REMOVED_COMPONENTS = "select id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked from ST_ComponentInstance where componentStatus = 'R' order by removeTime desc";
    private static final String INSERT_INSTANCE = "insert into ST_ComponentInstance(id,spaceId,name,componentName,description,createdBy,orderNum,createTime,updateTime,removeTime,componentStatus,updatedBy,removedBy,isPublic,isHidden,lang,isInheritanceBlocked) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_ST_COMPONENT_INSTANCE_SET = "update ST_ComponentInstance set";
    public static final String WHERE_ID = " where id = ?";
    private static final String UPDATE_COMPONENT_ORDER = "update ST_ComponentInstance set orderNum = ? where id = ?";
    private static final String UPDATE_COMPONENT_INHERITANCE = "update ST_ComponentInstance set isInheritanceBlocked = ? where id = ?";
    private static final String UPDATE_INSTANCE = "update ST_ComponentInstance set name = ?, description = ?, createdBy = ?, orderNum = ?, updateTime = ?, updatedBy = ?, componentStatus = ?, isPublic = ?, isHidden = ?, lang = ?, isInheritanceBlocked = ? where id = ?";
    private static final String IS_COMPONENT_INTO_BASKET = "select * from ST_ComponentInstance where name = ? and spaceId = ? and componentStatus = ? ";
    private static final String SEND_COMPONENT_IN_BASKET = "update ST_ComponentInstance set name = ?, removedBy = ?, removeTime = ?, componentStatus = ? where id = ?";
    private static final String RESTORE_COMPONENT_FROM_BASKET = "update ST_ComponentInstance set removedBy = ?, removeTime = ?, componentStatus = ? where id = ?";
    private static final String MOVE_COMPONENT_INSTANCE = "update ST_ComponentInstance set spaceId = ? where id = ?";

    public ComponentInstanceTable() {
        super("ST_ComponentInstance");
    }

    protected ComponentInstanceRow fetchComponentInstance(ResultSet rs) throws SQLException {
        ComponentInstanceRow i = new ComponentInstanceRow();
        i.id = rs.getInt(1);
        i.spaceId = rs.getInt(2);
        i.name = rs.getString(3);
        i.componentName = rs.getString(4);
        i.description = this.getNotNullString(rs.getString(5));
        i.createdBy = rs.getInt(6);
        if (rs.wasNull()) {
            i.createdBy = -1;
        }
        i.orderNum = rs.getInt(7);
        if (rs.wasNull()) {
            i.orderNum = -1;
        }
        i.createTime = rs.getString(8);
        i.updateTime = rs.getString(9);
        i.removeTime = rs.getString(10);
        i.status = rs.getString(11);
        i.updatedBy = rs.getInt(12);
        if (rs.wasNull()) {
            i.updatedBy = -1;
        }
        i.removedBy = rs.getInt(13);
        if (rs.wasNull()) {
            i.removedBy = -1;
        }
        i.publicAccess = rs.getInt(14);
        i.hidden = rs.getInt(15);
        i.lang = rs.getString(16);
        i.inheritanceBlocked = rs.getInt(17);
        return i;
    }

    public ComponentInstanceRow getComponentInstance(int id) throws SQLException {
        return (ComponentInstanceRow)this.getUniqueRow(SELECT_INSTANCE_BY_ID, id);
    }

    public ComponentInstanceRow[] getAllComponentInstancesInSpace(int spaceId) throws SQLException {
        List rows = this.getRows(SELECT_ALL_SPACE_INSTANCES, spaceId);
        return rows.toArray(new ComponentInstanceRow[0]);
    }

    public String[] getAllComponentInstanceIdsInSpace(int spaceId) throws SQLException {
        List<String> ids = this.getIds(SELECT_ALL_SPACE_INSTANCE_IDS, spaceId);
        return ids.toArray(new String[0]);
    }

    public ComponentInstanceRow[] getRemovedComponents() throws SQLException {
        List rows = this.getRows(SELECT_REMOVED_COMPONENTS);
        return rows.toArray(new ComponentInstanceRow[0]);
    }

    public ComponentInstanceRow[] getAllMatchingComponentInstances(ComponentInstanceRow sampleInstance) throws SQLException {
        String[] columns = new String[]{"componentName", "name", "description"};
        String[] values = new String[]{sampleInstance.componentName, sampleInstance.name, sampleInstance.description};
        List rows = this.getMatchingRows(INSTANCE_COLUMNS, columns, values);
        return rows.toArray(new ComponentInstanceRow[0]);
    }

    public void createComponentInstance(ComponentInstanceRow instance) throws SQLException {
        this.insertRow(INSERT_INSTANCE, instance);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, ComponentInstanceRow row) throws SQLException {
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        insert.setInt(2, row.spaceId);
        insert.setString(3, this.truncate(row.name, 100));
        insert.setString(4, this.truncate(row.componentName, 100));
        insert.setString(5, this.truncate(row.description, 500));
        if (row.createdBy == -1) {
            insert.setNull(6, 4);
        } else {
            insert.setInt(6, row.createdBy);
        }
        insert.setInt(7, row.orderNum);
        insert.setString(8, String.valueOf(new Date().getTime()));
        insert.setString(9, null);
        insert.setString(10, null);
        insert.setString(11, row.status);
        insert.setNull(12, 4);
        insert.setNull(13, 4);
        insert.setInt(14, row.publicAccess);
        insert.setInt(15, row.hidden);
        insert.setString(16, row.lang);
        insert.setInt(17, row.inheritanceBlocked);
    }

    public void updateComponentOrder(int componentId, int orderNum) throws SQLException {
        int[] values = new int[]{orderNum, componentId};
        this.updateRelation(UPDATE_COMPONENT_ORDER, values);
    }

    public void updateComponentInheritance(int componentId, boolean inheritanceBlocked) throws SQLException {
        int iInheritance = 0;
        if (inheritanceBlocked) {
            iInheritance = 1;
        }
        int[] values = new int[]{iInheritance, componentId};
        this.updateRelation(UPDATE_COMPONENT_INHERITANCE, values);
    }

    public void updateComponentInstance(ComponentInstanceRow instance) throws SQLException {
        this.updateRow(UPDATE_INSTANCE, instance);
    }

    /*
     * Exception decompiling
     */
    public boolean isComponentIntoBasket(int spaceId, String name) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void sendComponentToBasket(int id, String tempLabel, String userId) throws SQLException {
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement statement = connection.prepareStatement(SEND_COMPONENT_IN_BASKET);){
            statement.setString(1, tempLabel);
            statement.setInt(2, Integer.parseInt(userId));
            statement.setString(3, Long.toString(new Date().getTime()));
            statement.setString(4, "R");
            statement.setInt(5, id);
            statement.executeUpdate();
        }
    }

    public void restoreComponentFromBasket(int id) throws SQLException {
        try (Connection connection = DBUtil.openConnection();
             PreparedStatement statement = connection.prepareStatement(RESTORE_COMPONENT_FROM_BASKET);){
            statement.setNull(1, 4);
            statement.setNull(2, 12);
            statement.setNull(3, 12);
            statement.setInt(4, id);
            statement.executeUpdate();
        }
    }

    public void moveComponentInstance(int spaceId, int componentId) throws SQLException {
        int[] param = new int[]{spaceId, componentId};
        this.updateRelation(MOVE_COMPONENT_INSTANCE, param);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, ComponentInstanceRow row) throws SQLException {
        update.setString(1, this.truncate(row.name, 100));
        update.setString(2, this.truncate(row.description, 500));
        if (row.createdBy == -1) {
            update.setNull(3, 4);
        } else {
            update.setInt(3, row.createdBy);
        }
        update.setInt(4, row.orderNum);
        update.setString(5, String.valueOf(new Date().getTime()));
        if (row.updatedBy == -1) {
            update.setNull(6, 4);
        } else {
            update.setInt(6, row.updatedBy);
        }
        update.setString(7, row.status);
        update.setInt(8, row.publicAccess);
        update.setInt(9, row.hidden);
        update.setString(10, row.lang);
        update.setInt(11, row.inheritanceBlocked);
        update.setInt(12, row.id);
    }

    public void removeComponentInstance(int id) throws SQLException {
        UserRoleRow[] roles;
        ComponentInstanceRow instance = this.getComponentInstance(id);
        if (instance == null) {
            return;
        }
        OrganizationSchema schema = OrganizationSchema.get();
        UserRoleTable userRoleTable = schema.userRole();
        for (UserRoleRow role : roles = userRoleTable.getAllUserRolesOfInstance(id)) {
            userRoleTable.removeUserRole(role.getId());
        }
        schema.instanceData().removeInstanceData(id);
        this.updateRelation(DELETE_INSTANCE, id);
    }

    protected ComponentInstanceRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchComponentInstance(rs);
    }
}

