/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.silverpeas.core.admin.persistence.ComponentInstanceI18NRow;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.MapUtil;

@Repository
public class ComponentInstanceI18NTable
extends Table<ComponentInstanceI18NRow> {
    private static final String TABLENAME = "ST_ComponentInstanceI18N";
    private static final String COMPONENT_ID_FIELD = "componentId";
    private static final String COLUMNS = "id,componentId,lang,name,description";
    private static final String SELECT_TRANSLATIONS = "select id,componentId,lang,name,description from ST_ComponentInstanceI18N where componentId = ?";
    private static final String INSERT_TRANSLATION = "insert into ST_ComponentInstanceI18N(id,componentId,lang,name,description) values  (?, ?, ?, ?, ?)";
    private static final String UPDATE_TRANSLATION = "update ST_ComponentInstanceI18N set name = ?, description = ?  WHERE id = ? ";
    private static final String DELETE_TRANSLATION = "delete from ST_ComponentInstanceI18N where id = ?";
    private static final String DELETE_TRANSLATIONS = "delete from ST_ComponentInstanceI18N where componentId = ?";

    public ComponentInstanceI18NTable() {
        super(TABLENAME);
    }

    private ComponentInstanceI18NRow fetchTranslation(ResultSet rs) throws SQLException {
        ComponentInstanceI18NRow s = new ComponentInstanceI18NRow();
        s.id = rs.getInt(1);
        s.componentId = rs.getInt(2);
        s.lang = rs.getString(3);
        s.name = rs.getString(4);
        s.description = rs.getString(5);
        return s;
    }

    public List<ComponentInstanceI18NRow> getTranslations(int componentId) throws SQLException {
        return this.getRows(SELECT_TRANSLATIONS, componentId);
    }

    public Map<Integer, List<ComponentInstanceI18NRow>> getIndexedTranslations(Connection con, Collection<Integer> componentIds) throws SQLException {
        return JdbcSqlQuery.executeBySplittingOn(componentIds, (idBatch, result) -> JdbcSqlQuery.select((String)COLUMNS).from(new String[]{TABLENAME}).where(COMPONENT_ID_FIELD, new Object[0]).in(idBatch).executeWith(con, r -> {
            ComponentInstanceI18NRow translation = this.fetchTranslation((ResultSet)r);
            MapUtil.putAddList(result, translation.componentId, translation);
            return null;
        }));
    }

    public void createTranslation(ComponentInstanceI18NRow translation) throws SQLException {
        this.insertRow(INSERT_TRANSLATION, translation);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, ComponentInstanceI18NRow row) throws SQLException {
        row.id = this.getNextId();
        insert.setInt(1, row.id);
        insert.setInt(2, row.componentId);
        insert.setString(3, row.lang);
        insert.setString(4, this.truncate(row.name, 100));
        insert.setString(5, this.truncate(row.description, 400));
    }

    public void updateTranslation(ComponentInstanceI18NRow component) throws SQLException {
        this.updateRow(UPDATE_TRANSLATION, component);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, ComponentInstanceI18NRow row) throws SQLException {
        update.setString(1, this.truncate(row.name, 100));
        update.setString(2, this.truncate(row.description, 400));
        update.setInt(3, row.id);
    }

    public void removeTranslation(int id) throws SQLException {
        this.updateRelation(DELETE_TRANSLATION, id);
    }

    public void removeTranslations(int componentId) throws SQLException {
        this.updateRelation(DELETE_TRANSLATIONS, componentId);
    }

    protected ComponentInstanceI18NRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchTranslation(rs);
    }
}

