/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

abstract class ComponentLocalization {
    private final SilverpeasComponent component;
    private final String lang;
    private final LocalizationBundle bundle;

    protected ComponentLocalization(ComponentLocalization bundle) {
        this.component = bundle.component;
        this.lang = bundle.lang;
        this.bundle = bundle.bundle;
    }

    protected ComponentLocalization(SilverpeasComponent component, String lang) {
        this.component = component;
        this.lang = lang;
        this.bundle = ResourceLocator.getLocalizationBundle((String)this.getBundleName(component), (String)this.getLanguage());
    }

    public String getComponentName() {
        return this.component.getName();
    }

    public String getLanguage() {
        return this.lang;
    }

    protected String getLocalized(String bundleKey, Map<String, String> messages) {
        return Optional.of(this.bundle).filter(LocalizationBundle::exists).map(b -> {
            try {
                return b.getString(bundleKey);
            }
            catch (MissingResourceException ignore) {
                return null;
            }
        }).filter(StringUtil::isDefined).orElseGet(() -> {
            if (messages.containsKey(this.lang)) {
                return (String)messages.get(this.lang);
            }
            if (messages.containsKey(DisplayI18NHelper.getDefaultLanguage())) {
                return (String)messages.get(DisplayI18NHelper.getDefaultLanguage());
            }
            return DisplayI18NHelper.getLanguages().stream().filter(Predicate.not(this.lang::equals).and(Predicate.not(DisplayI18NHelper.getDefaultLanguage()::equals))).map(messages::get).filter(Objects::nonNull).findFirst().orElseThrow(() -> new MissingResourceException(String.format("Can't find localization into %s with key %s, or into %s XML descriptor", this.bundle.getBaseBundleName() + "_" + this.getLanguage() + ".properties", bundleKey, this.getComponentName()), this.getClass().getName(), bundleKey));
        });
    }

    private String getBundleName(SilverpeasComponent component) {
        String baseName = "xmlcomponents";
        String bundleName = component.isPersonal() ? "xmlcomponents.personals." + component.getName() : (component.isWorkflow() ? "xmlcomponents.workflows." + component.getName() : "xmlcomponents." + component.getName());
        return bundleName;
    }
}

