/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.client.Debug;
import com.novell.ldap.resources.ResourcesHandler;
import java.util.Locale;

public class LDAPException
extends Exception {
    private int resultCode = 0;
    private String messageOrKey = null;
    private Object[] arguments = null;
    private String matchedDN = null;
    private Throwable rootException = null;
    private String serverMessage = null;
    public static final int SUCCESS = 0;
    public static final int OPERATIONS_ERROR = 1;
    public static final int PROTOCOL_ERROR = 2;
    public static final int TIME_LIMIT_EXCEEDED = 3;
    public static final int SIZE_LIMIT_EXCEEDED = 4;
    public static final int COMPARE_FALSE = 5;
    public static final int COMPARE_TRUE = 6;
    public static final int AUTH_METHOD_NOT_SUPPORTED = 7;
    public static final int STRONG_AUTH_REQUIRED = 8;
    public static final int LDAP_PARTIAL_RESULTS = 9;
    public static final int REFERRAL = 10;
    public static final int ADMIN_LIMIT_EXCEEDED = 11;
    public static final int UNAVAILABLE_CRITICAL_EXTENSION = 12;
    public static final int CONFIDENTIALITY_REQUIRED = 13;
    public static final int SASL_BIND_IN_PROGRESS = 14;
    public static final int NO_SUCH_ATTRIBUTE = 16;
    public static final int UNDEFINED_ATTRIBUTE_TYPE = 17;
    public static final int INAPPROPRIATE_MATCHING = 18;
    public static final int CONSTRAINT_VIOLATION = 19;
    public static final int ATTRIBUTE_OR_VALUE_EXISTS = 20;
    public static final int INVALID_ATTRIBUTE_SYNTAX = 21;
    public static final int NO_SUCH_OBJECT = 32;
    public static final int ALIAS_PROBLEM = 33;
    public static final int INVALID_DN_SYNTAX = 34;
    public static final int IS_LEAF = 35;
    public static final int ALIAS_DEREFERENCING_PROBLEM = 36;
    public static final int INAPPROPRIATE_AUTHENTICATION = 48;
    public static final int INVALID_CREDENTIALS = 49;
    public static final int INSUFFICIENT_ACCESS_RIGHTS = 50;
    public static final int BUSY = 51;
    public static final int UNAVAILABLE = 52;
    public static final int UNWILLING_TO_PERFORM = 53;
    public static final int LOOP_DETECT = 54;
    public static final int NAMING_VIOLATION = 64;
    public static final int OBJECT_CLASS_VIOLATION = 65;
    public static final int NOT_ALLOWED_ON_NONLEAF = 66;
    public static final int NOT_ALLOWED_ON_RDN = 67;
    public static final int ENTRY_ALREADY_EXISTS = 68;
    public static final int OBJECT_CLASS_MODS_PROHIBITED = 69;
    public static final int AFFECTS_MULTIPLE_DSAS = 71;
    public static final int OTHER = 80;
    public static final int SERVER_DOWN = 81;
    public static final int LOCAL_ERROR = 82;
    public static final int ENCODING_ERROR = 83;
    public static final int DECODING_ERROR = 84;
    public static final int LDAP_TIMEOUT = 85;
    public static final int AUTH_UNKNOWN = 86;
    public static final int FILTER_ERROR = 87;
    public static final int USER_CANCELLED = 88;
    public static final int NO_MEMORY = 90;
    public static final int CONNECT_ERROR = 91;
    public static final int LDAP_NOT_SUPPORTED = 92;
    public static final int CONTROL_NOT_FOUND = 93;
    public static final int NO_RESULTS_RETURNED = 94;
    public static final int MORE_RESULTS_TO_RETURN = 95;
    public static final int CLIENT_LOOP = 96;
    public static final int REFERRAL_LIMIT_EXCEEDED = 97;
    public static final int INVALID_RESPONSE = 100;
    public static final int AMBIGUOUS_RESPONSE = 101;
    public static final int TLS_NOT_SUPPORTED = 112;

    public LDAPException() {
    }

    public LDAPException(String messageOrKey, int resultCode, String serverMsg) {
        this(messageOrKey, null, resultCode, serverMsg, null, null);
    }

    public LDAPException(String messageOrKey, Object[] arguments, int resultCode, String serverMsg) {
        this(messageOrKey, arguments, resultCode, serverMsg, null, null);
    }

    public LDAPException(String messageOrKey, int resultCode, String serverMsg, Throwable rootException) {
        this(messageOrKey, null, resultCode, serverMsg, null, rootException);
    }

    public LDAPException(String messageOrKey, Object[] arguments, int resultCode, String serverMsg, Throwable rootException) {
        this(messageOrKey, arguments, resultCode, serverMsg, null, rootException);
    }

    public LDAPException(String messageOrKey, int resultCode, String serverMsg, String matchedDN) {
        this(messageOrKey, null, resultCode, serverMsg, matchedDN, null);
    }

    public LDAPException(String messageOrKey, Object[] arguments, int resultCode, String serverMsg, String matchedDN) {
        this(messageOrKey, arguments, resultCode, serverMsg, matchedDN, null);
    }

    LDAPException(String messageOrKey, Object[] arguments, int resultCode, String serverMsg, String matchedDN, Throwable rootException) {
        super(ResourcesHandler.getMessage(messageOrKey, arguments));
        this.messageOrKey = messageOrKey;
        this.arguments = arguments;
        this.resultCode = resultCode;
        this.rootException = rootException;
        this.matchedDN = matchedDN;
        this.serverMessage = serverMsg;
        Debug.trace("Messages", "new LDAPException(Result=" + resultCode + ") " + super.getMessage());
    }

    public String resultCodeToString() {
        return ResourcesHandler.getResultString(this.resultCode);
    }

    public static String resultCodeToString(int code) {
        return ResourcesHandler.getResultString(code);
    }

    public String resultCodeToString(Locale locale) {
        return ResourcesHandler.getResultString(this.resultCode, locale);
    }

    public static String resultCodeToString(int code, Locale locale) {
        return ResourcesHandler.getResultString(code, locale);
    }

    public String getLDAPErrorMessage() {
        if (this.serverMessage != null && this.serverMessage.length() == 0) {
            return null;
        }
        return this.serverMessage;
    }

    public Throwable getCause() {
        return this.rootException;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getMatchedDN() {
        return this.matchedDN;
    }

    public String getMessage() {
        return this.resultCodeToString();
    }

    public String getLocalizedMessage() {
        return this.resultCodeToString();
    }

    public String toString() {
        return this.getExceptionString("LDAPException");
    }

    String getExceptionString(String exception) {
        String tmsg;
        String msg = ResourcesHandler.getMessage("TOSTRING", new Object[]{exception, super.getMessage(), new Integer(this.resultCode), this.resultCodeToString()});
        if (msg.equalsIgnoreCase("TOSTRING")) {
            msg = exception + ": (" + this.resultCode + ") " + this.resultCodeToString();
        }
        if (this.serverMessage != null && this.serverMessage.length() != 0) {
            tmsg = ResourcesHandler.getMessage("SERVER_MSG", new Object[]{exception, this.serverMessage});
            if (tmsg.equalsIgnoreCase("SERVER_MSG")) {
                tmsg = exception + ": Server Message: " + this.serverMessage;
            }
            msg = msg + '\n' + tmsg;
        }
        if (this.matchedDN != null) {
            tmsg = ResourcesHandler.getMessage("MATCHED_DN", new Object[]{exception, this.matchedDN});
            if (tmsg.equalsIgnoreCase("MATCHED_DN")) {
                tmsg = exception + ": Matched DN: " + this.matchedDN;
            }
            msg = msg + '\n' + tmsg;
        }
        if (this.rootException != null) {
            msg = msg + '\n' + this.rootException.toString();
        }
        return msg;
    }
}

