/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.configuration;

import org.jasig.cas.client.configuration.ConfigurationKey;
import org.jasig.cas.client.configuration.ConfigurationStrategy;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConfigurationStrategy
implements ConfigurationStrategy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public final boolean getBoolean(ConfigurationKey<Boolean> configurationKey) {
        return this.getValue(configurationKey, new Parser<Boolean>(){

            @Override
            public Boolean parse(String value) {
                return CommonUtils.toBoolean(value);
            }
        });
    }

    @Override
    public final long getLong(final ConfigurationKey<Long> configurationKey) {
        return this.getValue(configurationKey, new Parser<Long>(){

            @Override
            public Long parse(String value) {
                return CommonUtils.toLong(value, (Long)configurationKey.getDefaultValue());
            }
        });
    }

    @Override
    public final int getInt(final ConfigurationKey<Integer> configurationKey) {
        return this.getValue(configurationKey, new Parser<Integer>(){

            @Override
            public Integer parse(String value) {
                return CommonUtils.toInt(value, (Integer)configurationKey.getDefaultValue());
            }
        });
    }

    @Override
    public final String getString(ConfigurationKey<String> configurationKey) {
        return this.getValue(configurationKey, new Parser<String>(){

            @Override
            public String parse(String value) {
                return value;
            }
        });
    }

    @Override
    public <T> Class<? extends T> getClass(final ConfigurationKey<Class<? extends T>> configurationKey) {
        return this.getValue(configurationKey, new Parser<Class<? extends T>>(){

            @Override
            public Class<? extends T> parse(String value) {
                try {
                    return ReflectUtils.loadClass(value);
                }
                catch (IllegalArgumentException e) {
                    return (Class)configurationKey.getDefaultValue();
                }
            }
        });
    }

    private <T> T getValue(ConfigurationKey<T> configurationKey, Parser<T> parser) {
        String value = this.getWithCheck(configurationKey);
        if (CommonUtils.isBlank(value)) {
            this.logger.trace("No value found for property {}, returning default {}", (Object)configurationKey.getName(), configurationKey.getDefaultValue());
            return configurationKey.getDefaultValue();
        }
        this.logger.trace("Loaded property {} with value {}", (Object)configurationKey.getName(), configurationKey.getDefaultValue());
        return parser.parse(value);
    }

    private String getWithCheck(ConfigurationKey configurationKey) {
        CommonUtils.assertNotNull(configurationKey, "configurationKey cannot be null");
        return this.get(configurationKey);
    }

    protected abstract String get(ConfigurationKey var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Parser<T> {
        public T parse(String var1);
    }
}

