/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.pdc.pdc.model.Axis;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.thesaurus.model.ThesaurusException;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.pdc.PdcAxis;
import org.silverpeas.core.webapi.pdc.UserThesaurusHolder;

@XmlRootElement
public class PdcEntity
implements WebEntity {
    private static final long serialVersionUID = 6798294501268706300L;
    public static final UserThesaurusHolder NoThesaurus = null;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement
    private List<PdcAxis> axis = new ArrayList<PdcAxis>();

    public static PdcEntity aPdcEntityWithUsedAxis(List<UsedAxis> usedAxis, String inLanguage, URI atURI, UserThesaurusHolder withThesaurus) throws ThesaurusException {
        return new PdcEntity(atURI).withAsAxis(PdcEntity.fromUsedAxis(usedAxis, inLanguage, withThesaurus));
    }

    public static PdcEntity aPdcEntityWithAxis(List<Axis> usedAxis, String inLanguage, URI atURI, UserThesaurusHolder withThesaurus) throws ThesaurusException {
        return new PdcEntity(atURI).withAsAxis(PdcEntity.fromAxis(usedAxis, inLanguage, withThesaurus));
    }

    public static List<UsedAxis> withAxis(List<UsedAxis> axis) {
        return axis;
    }

    public static String inLanguage(String language) {
        return language;
    }

    public URI getURI() {
        return this.uri;
    }

    public List<PdcAxis> getAxis() {
        return Collections.unmodifiableList(this.axis);
    }

    public PdcEntity withAsAxis(List<PdcAxis> axis) {
        this.axis.addAll(axis);
        return this;
    }

    public static URI atURI(URI uri) {
        return uri;
    }

    protected PdcEntity() {
    }

    private static List<PdcAxis> fromUsedAxis(List<UsedAxis> theAxisToUse, String inLanguage, UserThesaurusHolder usingThesaurus) throws ThesaurusException {
        ArrayList<PdcAxis> axis = new ArrayList<PdcAxis>();
        for (UsedAxis usedAxis : theAxisToUse) {
            axis.add(PdcAxis.fromTheUsedAxis(usedAxis, inLanguage, usingThesaurus));
        }
        return axis;
    }

    private static List<PdcAxis> fromAxis(List<Axis> theAxis, String inLanguage, UserThesaurusHolder usingThesaurus) throws ThesaurusException {
        ArrayList<PdcAxis> axis = new ArrayList<PdcAxis>();
        for (Axis anAxis : theAxis) {
            axis.add(PdcAxis.fromTheAxis(anAxis, inLanguage, usingThesaurus));
        }
        return axis;
    }

    private PdcEntity(URI atURI) {
        this.uri = atURI;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdcEntity other = (PdcEntity)obj;
        if (!(this.uri == other.uri || this.uri != null && this.uri.equals(other.uri))) {
            return false;
        }
        return this.axis == other.axis || this.axis != null && this.axis.equals(other.axis);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 47 * hash + (this.axis != null ? this.axis.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder axisArray = new StringBuilder("[");
        for (PdcAxis anAxis : this.getAxis()) {
            axisArray.append(anAxis.toString()).append(", ");
        }
        if (axisArray.length() > 1) {
            axisArray.replace(axisArray.length() - 2, axisArray.length(), "]");
        } else {
            axisArray.append("]");
        }
        return "PdcEntity{uri=" + String.valueOf(this.getURI()) + ", axis=" + axisArray.toString() + "}";
    }
}

