/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.media.streaming;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.silverpeas.core.io.media.Definition;
import org.silverpeas.core.media.streaming.StreamingProvider;
import org.silverpeas.core.media.streaming.StreamingProvidersRegistry;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.media.MediaDefinitionEntity;
import org.silverpeas.core.webapi.media.streaming.OembedDataEntity;
import org.silverpeas.core.webapi.media.streaming.StreamingProviderDataEntityFactory;
import org.silverpeas.core.webapi.media.streaming.StreamingRequester;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StreamingProviderDataEntity
implements WebEntity {
    private static final long serialVersionUID = 4017230238128160967L;
    public static final String NAME = "default";
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlTransient
    private String originalUrl;
    @XmlElement
    private String provider;
    @XmlElement
    private String title;
    @XmlElement
    private String author;
    @XmlElement
    private String formattedDurationHMS;
    @XmlElement
    private MediaDefinitionEntity definition = MediaDefinitionEntity.createFrom(Definition.fromZero());
    @XmlElement
    private String embedHtml;
    @XmlElement
    private URI thumbnailUrl;
    @XmlElement
    private MediaDefinitionEntity thumbnailDefinition;
    @XmlElement
    private List<URI> thumbnailPreviewUrls = new ArrayList<URI>();

    public static Optional<StreamingProviderDataEntity> from(String homepageUrl) {
        return StreamingProvidersRegistry.get().getFromUrl(homepageUrl).map(p -> {
            OembedDataEntity oembedData = (OembedDataEntity)JSONCodec.decode((String)StreamingRequester.getJsonOembedAsString(homepageUrl), OembedDataEntity.class);
            StreamingProviderDataEntity entity = StreamingProviderDataEntityFactory.get().createWith((StreamingProvider)p, oembedData);
            entity.originalUrl = homepageUrl;
            return entity;
        }).map(e -> {
            if (URLUtil.getCurrentServerURL().startsWith("https")) {
                e.forceSecureEmbedUrl();
            }
            return e;
        });
    }

    public StreamingProviderDataEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    protected StreamingProviderDataEntity(StreamingProvider streamingProvider, OembedDataEntity oembedData) {
        this.provider = streamingProvider.getName();
        this.title = oembedData.getTitle();
        this.author = oembedData.getAuthor();
        this.embedHtml = oembedData.getHtml();
        String givenThumbnailUrl = oembedData.getThumbnailUrl();
        if (StringUtil.isDefined((String)givenThumbnailUrl)) {
            this.thumbnailUrl = URI.create(givenThumbnailUrl);
            String thumbnailWidth = oembedData.getThumbnailWidth();
            String thumbnailHeight = oembedData.getThumbnailHeight();
            if (StringUtil.isDefined((String)thumbnailWidth) && StringUtil.isDefined((String)thumbnailHeight)) {
                this.thumbnailDefinition = MediaDefinitionEntity.createFrom(Definition.of((int)Integer.parseInt(thumbnailWidth.replaceAll("[^0-9].", "")), (int)Integer.parseInt(thumbnailHeight.replaceAll("[^0-9].", ""))));
            }
        }
    }

    protected StreamingProviderDataEntity() {
    }

    public URI getURI() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public StreamingProvider getProvider() {
        return StreamingProvidersRegistry.get().getByName(this.provider).orElse(null);
    }

    public void setProvider(StreamingProvider provider) {
        this.provider = provider.getName();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getFormattedDurationHMS() {
        return this.formattedDurationHMS;
    }

    public void setFormattedDurationHMS(String formattedDurationHMS) {
        this.formattedDurationHMS = formattedDurationHMS;
    }

    public MediaDefinitionEntity getDefinition() {
        return this.definition;
    }

    public void setDefinition(MediaDefinitionEntity definition) {
        this.definition = definition;
    }

    public String getSilverpeasEmbedUrl() {
        return UriBuilder.fromUri((String)URLUtil.getApplicationURL()).path("services/media/streaming/player").queryParam("url", new Object[]{this.originalUrl}).build(new Object[0]).toString();
    }

    public String getEmbedHtml() {
        return this.embedHtml;
    }

    public void setEmbedHtml(String embedHtml) {
        this.embedHtml = embedHtml;
    }

    public void forceSecureEmbedUrl() {
        this.setEmbedHtml(this.getEmbedHtml().replace("http://", "https://"));
    }

    public URI getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(URI thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public MediaDefinitionEntity getThumbnailDefinition() {
        return this.thumbnailDefinition;
    }

    public void setThumbnailDefinition(MediaDefinitionEntity thumbnailDefinition) {
        this.thumbnailDefinition = thumbnailDefinition;
    }

    public List<URI> getThumbnailPreviewUrls() {
        return this.thumbnailPreviewUrls;
    }

    public void setThumbnailPreviewUrls(List<URI> thumbnailPreviewUrls) {
        this.thumbnailPreviewUrls = thumbnailPreviewUrls;
    }
}

