/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.look.delegate;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.UserFavoriteSpaceService;
import org.silverpeas.core.admin.space.UserFavoriteSpaceServiceProvider;
import org.silverpeas.core.admin.space.model.UserFavoriteSpaceVO;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.personalization.UserMenuDisplay;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.look.SilverpeasLook;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.kernel.util.StringUtil;

public class LookWebDelegate {
    private OrganizationController organizationController;
    private final User user;
    private final UserPreferences userPreference;
    private final LookHelper lookHelper;
    private final GraphicElementFactory gef;
    private List<UserFavoriteSpaceVO> userFavoriteSpaces = null;
    private List<String> userFavoriteSpaceIds = null;
    private UserFavoriteSpaceService userFavoriteSpaceService;

    public String getUserFavorite(SpaceInstLight space, boolean forceGettingFavorite) {
        String favorite = "false";
        if (forceGettingFavorite || UserMenuDisplay.DISABLE != this.getUserMenuDisplay()) {
            if (this.getUserFavoriteSpaceIds().contains(String.valueOf(space.getLocalId()))) {
                favorite = "true";
            } else if (this.getUserFavoriteSpaceService().containsFavoriteSubSpace(space, this.getUserFavoriteSpaces(), this.getUserId())) {
                favorite = "contains";
            }
        }
        return favorite;
    }

    public void addToUserFavorites(SpaceInstLight space) {
        this.getUserFavoriteSpaceService().addUserFavoriteSpace(new UserFavoriteSpaceVO(UserDetail.from((User)this.getUser()), space));
        this.clearFavoriteCache();
    }

    public void removeFromUserFavorites(SpaceInstLight space) {
        this.getUserFavoriteSpaceService().removeUserFavoriteSpace(new UserFavoriteSpaceVO(UserDetail.from((User)this.getUser()), space));
        this.clearFavoriteCache();
    }

    public String getLook(SpaceInstLight space) {
        String look = space.getLook();
        while (!space.isRoot() && !StringUtil.isDefined((String)look)) {
            space = this.getOrganisationController().getSpaceInstLightById(space.getFatherId());
            look = space.getLook();
        }
        if (!StringUtil.isDefined((String)look)) {
            look = this.getGraphicalElements().getDefaultLookName();
        }
        return look;
    }

    public String getWallpaper(SpaceInstLight space) {
        String wallpaper = SilverpeasLook.getSilverpeasLook().getWallpaperOfSpace(String.valueOf(space.getLocalId()));
        return wallpaper == null ? "" : wallpaper;
    }

    public String getCSS(SpaceInstLight space) {
        String css = SilverpeasLook.getSilverpeasLook().getCSSOfSpace(String.valueOf(space.getLocalId()));
        return css == null ? "" : css;
    }

    private UserMenuDisplay getUserMenuDisplay() {
        return this.getHelper().getDisplayUserMenu();
    }

    private List<UserFavoriteSpaceVO> getUserFavoriteSpaces() {
        if (this.userFavoriteSpaces == null) {
            this.userFavoriteSpaces = this.getUserFavoriteSpaceService().getListUserFavoriteSpace(this.getUserId());
        }
        return this.userFavoriteSpaces;
    }

    private List<String> getUserFavoriteSpaceIds() {
        if (this.userFavoriteSpaceIds == null) {
            this.userFavoriteSpaceIds = new ArrayList<String>();
            for (UserFavoriteSpaceVO favoriteUserSpace : this.getUserFavoriteSpaces()) {
                this.userFavoriteSpaceIds.add("" + favoriteUserSpace.getSpaceId());
            }
        }
        return this.userFavoriteSpaceIds;
    }

    private void clearFavoriteCache() {
        this.userFavoriteSpaces = null;
        this.userFavoriteSpaceIds = null;
    }

    public static LookWebDelegate getInstance(User user, UserPreferences userPreference, HttpServletRequest request) {
        return new LookWebDelegate(user, userPreference, request);
    }

    private LookWebDelegate(User user, UserPreferences userPreference, HttpServletRequest request) {
        this.user = user;
        this.userPreference = userPreference;
        this.lookHelper = (LookHelper)request.getSession().getAttribute("Silverpeas_LookHelper");
        this.gef = (GraphicElementFactory)request.getSession().getAttribute("SessionGraphicElementFactory");
        if (this.lookHelper != null) {
            this.initializeUserMenuDisplay(request);
        }
    }

    private void initializeUserMenuDisplay(HttpServletRequest request) {
        UserMenuDisplay displayMode = this.getHelper().getDisplayUserMenu();
        if (this.getHelper().isMenuPersonalisationEnabled()) {
            if (StringUtil.isDefined((String)request.getParameter("UserMenuDisplayMode"))) {
                displayMode = UserMenuDisplay.valueOf((String)request.getParameter("UserMenuDisplayMode"));
            } else if (this.userPreference.getDisplay().isNotDefault() && !UserMenuDisplay.ALL.equals((Object)displayMode) && !UserMenuDisplay.BOOKMARKS.equals((Object)displayMode)) {
                displayMode = this.userPreference.getDisplay();
            }
        }
        this.getHelper().setDisplayUserMenu(displayMode);
    }

    private User getUser() {
        return this.user;
    }

    private String getUserId() {
        return this.getUser().getId();
    }

    public LookHelper getHelper() {
        return this.lookHelper;
    }

    private GraphicElementFactory getGraphicalElements() {
        return this.gef;
    }

    private OrganizationController getOrganisationController() {
        if (this.organizationController == null) {
            this.organizationController = OrganizationControllerProvider.getOrganisationController();
        }
        return this.organizationController;
    }

    private UserFavoriteSpaceService getUserFavoriteSpaceService() {
        if (this.userFavoriteSpaceService == null) {
            this.userFavoriteSpaceService = UserFavoriteSpaceServiceProvider.getUserFavoriteSpaceService();
        }
        return this.userFavoriteSpaceService;
    }
}

