/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.buttons;

import java.io.Writer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.html.SupportedWebPlugin;
import org.silverpeas.core.html.WebPlugin;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.JavascriptPluginInclusion;
import org.silverpeas.core.web.util.viewgenerator.html.buttons.ButtonTag;
import org.silverpeas.kernel.util.StringUtil;

abstract class AbstractContributionManagementContextTag
extends TagSupport {
    private static final long serialVersionUID = 317414465687842654L;

    public abstract String getJsValidationCallbackMethodName();

    abstract List<Item> getItems();

    public AbstractContributionManagementContextTag() {
        this.init();
    }

    public void release() {
        super.release();
        this.init();
    }

    abstract void init();

    public int doEndTag() throws JspException {
        ButtonTag buttonTag = (ButtonTag)AbstractContributionManagementContextTag.findAncestorWithClass((Tag)this, ButtonTag.class);
        if (buttonTag != null) {
            buttonTag.setActionPreProcessing("");
            ElementContainer xhtml = new ElementContainer();
            xhtml.addElement((Element)WebPlugin.get().getHtml(SupportedWebPlugin.Constants.CONTRIBUTIONMODICTX, this.getRequest().getUserLanguage()));
            xhtml.addElement((Element)new script().setType("text/javascript").addElement(JavascriptPluginInclusion.getDynamicSubscriptionJavascriptLoadContent(null)));
            xhtml.output((Writer)this.pageContext.getOut());
            buttonTag.setActionPreProcessing(this.renderJs());
            return 6;
        }
        throw new JspException(((Object)((Object)this)).getClass().getSimpleName() + " must be wrapped by " + ButtonTag.class.getSimpleName());
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    protected HttpRequest getRequest() {
        return (HttpRequest)this.pageContext.getRequest();
    }

    protected String renderJs() {
        List<Item> items = this.getItems();
        StringBuilder sb = new StringBuilder();
        sb.append("jQuery.contributionModificationContext.validateOnUpdate({");
        sb.append("  items:[");
        sb.append(items.stream().map(this::renderContributionObject).collect(Collectors.joining(",")));
        sb.append("  ]");
        sb.append("  ,callback: function() {");
        sb.append(this.renderSubscriptionJs(items));
        sb.append("  }");
        if (StringUtil.isDefined((String)this.getJsValidationCallbackMethodName())) {
            sb.append("  ,validationCallback:").append(this.getJsValidationCallbackMethodName());
        }
        sb.append("});");
        return sb.toString();
    }

    protected String renderContributionObject(Item item) {
        ContributionIdentifier cId = Optional.ofNullable(item.contributionId).orElseGet(() -> {
            GraphicElementFactory gef = (GraphicElementFactory)this.pageContext.getSession().getAttribute("SessionGraphicElementFactory");
            String componentId = gef.getComponentIdOfCurrentRequest();
            return ContributionIdentifier.from((String)componentId, (String)componentId, (String)"UNKNOWN");
        });
        String status = item.contributionStatus != null ? String.format("'%s'", item.contributionStatus) : "undefined";
        String locationId = item.location != null && item.location.getComponentInstanceId().equals(item.contributionId.getComponentInstanceId()) ? String.format("'%s'", item.location.getLocalId()) : "undefined";
        String indexable = item.contributionIndexable != null ? item.contributionIndexable.toString().toLowerCase() : "true";
        return String.format("{contributionId:{componentInstanceId:'%s',localId:'%s',type:'%s'},status:%s,locationId:%s,indexable:%s}", cId.getComponentInstanceId(), cId.getLocalId(), cId.getType(), status, locationId, indexable);
    }

    protected String renderSubscriptionJs(List<Item> items) {
        GraphicElementFactory gef = (GraphicElementFactory)this.pageContext.getSession().getAttribute("SessionGraphicElementFactory");
        String componentId = gef.getComponentIdOfCurrentRequest();
        boolean tabComments = StringUtil.getBooleanValue((String)OrganizationController.get().getComponentParameterValue(componentId, "tabComments"));
        boolean comments = StringUtil.getBooleanValue((String)OrganizationController.get().getComponentParameterValue(componentId, "comments"));
        StringBuilder sb = new StringBuilder();
        sb.append("jQuery.subscription.confirmNotificationSendingOnUpdate({items:[");
        sb.append(items.stream().map(i -> this.renderContributionSubscriptionItem(componentId, (Item)i, tabComments || comments)).collect(Collectors.joining(",")));
        sb.append("  ],callback: function() {");
        sb.append("    {action};");
        sb.append("  }");
        if (StringUtil.isDefined((String)this.getJsValidationCallbackMethodName())) {
            sb.append("  ,validationCallback:").append(this.getJsValidationCallbackMethodName());
        }
        sb.append("});");
        return sb.toString();
    }

    protected String renderContributionSubscriptionItem(String componentId, Item item, boolean isComment) {
        StringBuilder sb = new StringBuilder();
        sb.append("{contribution:").append(this.renderContributionObject(item));
        sb.append(",subscription:{");
        sb.append("  componentInstanceId:'").append(componentId).append("'");
        SubscriptionResourceType type = item.subscriptionResourceType;
        sb.append("  ,type:").append("$.subscription.subscriptionType.").append(type.getName());
        if (CommonSubscriptionResourceConstants.COMPONENT != type) {
            sb.append("  ,resourceId:'").append(item.subscriptionResourceId).append("'");
        }
        sb.append("  }");
        if (isComment) {
            sb.append("  ,comment:{");
            sb.append("saveNote : true");
            sb.append("}");
        }
        return sb.append("}").toString();
    }

    static class Item {
        ContributionIdentifier contributionId;
        ContributionStatus contributionStatus;
        Location location;
        SubscriptionResourceType subscriptionResourceType = CommonSubscriptionResourceConstants.COMPONENT;
        String subscriptionResourceId = null;
        Boolean contributionIndexable = true;

        Item() {
        }
    }
}

