/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane;

public class ArrayPaneTag
extends TagSupport {
    public static final String ARRAY_PANE_PAGE_ATT = "pageContextArrayPane";
    private static final long serialVersionUID = 1370094709020971218L;
    private String var;
    private String title;
    private String summary;
    private String routingAddress;
    private boolean export;
    private String lineMoveCallback;
    private boolean movableLines;
    private int numberLinesPerPage;

    public ArrayPaneTag() {
        this.init();
    }

    void init() {
        this.var = null;
        this.title = null;
        this.summary = null;
        this.routingAddress = null;
        this.numberLinesPerPage = GraphicElementFactory.getSettings().getInteger("Pagination.NumberPerPageThreshold", 10);
    }

    public void release() {
        super.release();
        this.init();
    }

    public int doStartTag() throws JspException {
        GraphicElementFactory gef = (GraphicElementFactory)this.pageContext.getSession().getAttribute("SessionGraphicElementFactory");
        ArrayPane arrayPane = gef.getArrayPane(this.var, this.routingAddress, this.pageContext.getRequest(), this.pageContext.getSession());
        if (this.title != null) {
            arrayPane.setTitle(this.title);
        }
        if (this.summary != null) {
            arrayPane.setSummary(this.summary);
        }
        arrayPane.setExportData(this.export);
        arrayPane.setVisibleLineNumber(this.numberLinesPerPage);
        arrayPane.setMovableLines(this.movableLines);
        arrayPane.setLineMoveCallback(this.lineMoveCallback);
        this.pageContext.setAttribute(ARRAY_PANE_PAGE_ATT, (Object)arrayPane);
        return 1;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            ArrayPane arrayPane = this.getArrayPane();
            this.pageContext.removeAttribute(ARRAY_PANE_PAGE_ATT);
            out.println(arrayPane.print());
        }
        catch (IOException e) {
            throw new JspException("ArrayPane Tag", (Throwable)e);
        }
        return 6;
    }

    public ArrayPane getArrayPane() {
        return (ArrayPane)this.pageContext.getAttribute(ARRAY_PANE_PAGE_ATT);
    }

    public String getRoutingAddress() {
        return this.routingAddress;
    }

    public void setRoutingAddress(String routingAddress) {
        this.routingAddress = routingAddress;
    }

    public void setVar(String name) {
        this.var = name;
    }

    public void setTitle(String title2) {
        this.title = title2;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    public void setNumberLinesPerPage(int numberLinesPerPage) {
        this.numberLinesPerPage = numberLinesPerPage;
    }

    public void setMovableLines(boolean movable) {
        this.movableLines = movable;
    }

    public void setOnLineMove(String callback) {
        this.lineMoveCallback = callback;
    }
}

