/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.export;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.csv.CSVRow;
import org.silverpeas.core.util.html.HtmlCleaner;
import org.silverpeas.core.web.export.ExportCSVBuilder;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayColumn;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.util.StringUtil;

public class ExportServlet
extends HttpServlet {
    private static final long serialVersionUID = 1717365114830659355L;
    private static final String TYPE_ARRAYPANE = "ArrayPane";
    private final HtmlCleaner cleaner = new HtmlCleaner();

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Optional<ExportCSVBuilder> csvBuilder = ExportCSVBuilder.getFrom(HttpRequest.decorate((HttpServletRequest)request));
        if (!csvBuilder.isPresent()) {
            String type = request.getParameter("type");
            String name = request.getParameter("name");
            if (TYPE_ARRAYPANE.equals(type)) {
                csvBuilder = this.exportArrayPane(name);
            }
        }
        if (csvBuilder.isPresent()) {
            csvBuilder.get().sendTo(request, response);
        }
    }

    private Optional<ExportCSVBuilder> exportArrayPane(String name) throws IOException {
        ExportCSVBuilder csvBuilder = new ExportCSVBuilder();
        if (StringUtil.isDefined((String)name)) {
            SimpleCache cache = CacheAccessorProvider.getSessionCacheAccessor().getCache();
            List columns = (List)cache.get((Object)(name + "_columns"));
            CSVRow header = new CSVRow();
            for (ArrayColumn curCol : columns) {
                header.addCell((Object)curCol.getTitle());
            }
            csvBuilder.setHeader(header);
            List lines = (List)cache.get((Object)(name + "_lines"));
            for (ArrayLine curLine : lines) {
                CSVRow row = new CSVRow();
                for (ArrayColumn curCol : columns) {
                    String fullCell = curLine.getCellAt(curCol.getColumnNumber()).print();
                    String cleanCell = this.cleanHtmlCode(fullCell);
                    cleanCell = cleanCell.replaceAll("[\\r\\n]", "");
                    row.addCell((Object)cleanCell);
                }
                csvBuilder.addLine(row);
            }
        }
        return Optional.of(csvBuilder);
    }

    private String cleanHtmlCode(String html2) throws IOException {
        return this.cleaner.cleanHtmlFragment(html2);
    }
}

