/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar.ical;

import com.rometools.rome.io.XmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.RRule;
import org.silverpeas.core.personalorganizer.model.Category;
import org.silverpeas.core.personalorganizer.model.JournalHeader;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.web.tools.agenda.control.AgendaException;
import org.silverpeas.core.web.tools.agenda.control.AgendaSessionController;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class ImportIcalManager {
    private static final long YEAR = 31536000000L;
    private static String charset = null;
    private AgendaSessionController agendaSessionController;
    private SilverpeasCalendar calendarService;

    public ImportIcalManager(AgendaSessionController agendaSessionController) {
        this.agendaSessionController = agendaSessionController;
        this.setCalendarBm();
    }

    public static void setCharset(String aCharset) {
        charset = aCharset;
    }

    public static String getCharset() {
        return charset;
    }

    public String importIcalAgenda(File file) {
        String returnCode;
        String charsetUsed = this.getCharsetForImport();
        try (XmlReader xr = new XmlReader(file);){
            if (StringUtil.isDefined((String)xr.getEncoding())) {
                charsetUsed = xr.getEncoding();
            }
            returnCode = this.importFrom(file, charsetUsed);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            returnCode = "1";
        }
        return returnCode;
    }

    @Nonnull
    private String importFrom(File file, String charsetUsed) {
        String returnCode;
        try (InputStreamReader inputStream = new InputStreamReader((InputStream)new FileInputStream(file), charsetUsed);){
            CalendarBuilder builder = new CalendarBuilder();
            Calendar calendar = builder.build((Reader)inputStream);
            this.importAllEvents(calendar);
            returnCode = "0";
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            returnCode = "1";
        }
        return returnCode;
    }

    private void importAllEvents(Calendar calendar) throws ParseException, AgendaException {
        for (CalendarComponent o : calendar.getComponents("VEVENT")) {
            Collection<Date> reccurenceDates;
            VEvent eventIcal = (VEvent)o;
            String startDate = this.getFieldEvent(eventIcal.getProperty("DTSTART"));
            String endDate = this.getFieldEvent(eventIcal.getProperty("DTEND"));
            Date startDay = this.getDay(startDate);
            String startHour = this.getHour(startDate);
            Date endDay = this.getDay(endDate);
            String endHour = this.getHour(endDate);
            long duration = endDay.getTime() - startDay.getTime();
            boolean allDay = false;
            if ("00:00".equals(startHour) && "00:00".equals(endHour) || !StringUtil.isDefined((String)startHour) && !StringUtil.isDefined((String)endHour)) {
                startHour = "";
                endHour = "";
                allDay = true;
            }
            if ((reccurenceDates = ImportIcalManager.getRecurrenceDates(eventIcal)).isEmpty()) {
                String description = this.getFieldEvent(eventIcal.getProperty("DESCRIPTION"));
                String name = this.getName((Component)eventIcal, description);
                String priority = this.getPriority(eventIcal);
                String classification = this.getFieldEvent(eventIcal.getProperty("CLASS"));
                String idEvent = this.isExist((Component)eventIcal);
                if (StringUtil.isDefined((String)idEvent)) {
                    this.agendaSessionController.updateJournal(idEvent, name, description, priority, classification, (java.util.Date)startDay, startHour, (java.util.Date)endDay, endHour);
                } else {
                    idEvent = this.agendaSessionController.addJournal(name, description, priority, classification, (java.util.Date)startDay, startHour, (java.util.Date)endDay, endHour);
                }
                this.processCategories((Component)eventIcal, idEvent);
                continue;
            }
            this.importAllRecurrenceDates(eventIcal, startHour, endHour, duration, allDay, reccurenceDates);
        }
    }

    private void importAllRecurrenceDates(VEvent eventIcal, String startHour, String endHour, long duration, boolean allDay, Collection<Date> recurrenceDates) throws ParseException, AgendaException {
        String description = this.getFieldEvent(eventIcal.getProperty("DESCRIPTION"));
        String name = this.getName((Component)eventIcal, description);
        String priority = this.getPriority(eventIcal);
        String classification = this.getFieldEvent(eventIcal.getProperty("CLASS"));
        Iterator<Date> iterator = recurrenceDates.iterator();
        while (iterator.hasNext()) {
            String idEvent;
            Date recurrenceDate;
            Date startDay = recurrenceDate = iterator.next();
            long newEndDay = startDay.getTime() + duration;
            DateTime endDay = new DateTime(newEndDay);
            if (allDay) {
                GregorianCalendar gregCalendar = new GregorianCalendar();
                gregCalendar.setTime((java.util.Date)endDay);
                gregCalendar.add(5, -1);
                endDay = new Date(gregCalendar.getTime());
            }
            if (StringUtil.isDefined((String)(idEvent = this.isExist((Component)eventIcal, startDay, (Date)endDay, startHour)))) {
                this.agendaSessionController.updateJournal(idEvent, name, description, priority, classification, (java.util.Date)startDay, startHour, (java.util.Date)endDay, endHour);
            } else {
                idEvent = this.agendaSessionController.addJournal(name, description, priority, classification, (java.util.Date)startDay, startHour, (java.util.Date)endDay, endHour);
            }
            this.processCategories((Component)eventIcal, idEvent);
        }
    }

    private String getPriority(VEvent eventIcal) {
        String priority = this.getFieldEvent(eventIcal.getProperty("PRIORITY"));
        if (!StringUtil.isDefined((String)priority)) {
            priority = Priority.UNDEFINED.getValue();
        }
        return priority;
    }

    private String getCharsetForImport() {
        String charsetUsed = StringUtil.isDefined((String)charset) ? charset : this.agendaSessionController.getSettings().getString("defaultCharset");
        return charsetUsed;
    }

    private String isExist(Component eventIcal) throws ParseException {
        return this.isExist(eventIcal, null, null, null);
    }

    private String isExist(Component eventIcal, Date startDateReccurent, Date endDateReccurent, String startHourReccurent) throws ParseException {
        String description = this.getFieldEvent(eventIcal.getProperty("DESCRIPTION"));
        String name = this.getName(eventIcal, description);
        String startDate = DateUtil.date2SQLDate((java.util.Date)this.getDay(this.getFieldEvent(eventIcal.getProperty("DTSTART"))));
        String endDate = DateUtil.date2SQLDate((java.util.Date)this.getDay(this.getFieldEvent(eventIcal.getProperty("DTEND"))));
        String startHour = this.getHour(this.getFieldEvent(eventIcal.getProperty("DTSTART")));
        if (startDateReccurent != null) {
            startDate = DateUtil.date2SQLDate((java.util.Date)startDateReccurent);
            endDate = DateUtil.date2SQLDate((java.util.Date)endDateReccurent);
            startHour = startHourReccurent;
        }
        return this.findEvent(name, startDate, startHour, endDate);
    }

    private String findEvent(String name, String startDate, String startHour, String endDate) {
        Collection events = this.calendarService.getPeriodSchedulablesForUser(startDate, endDate, this.agendaSessionController.getAgendaUserId(), null, this.agendaSessionController.getParticipationStatus().getString());
        for (JournalHeader eventAgenda : events) {
            if (!eventAgenda.getName().equals(name) || !DateUtil.date2SQLDate((java.util.Date)eventAgenda.getStartDate()).equals(startDate)) continue;
            if (StringUtil.isDefined((String)eventAgenda.getStartHour()) && StringUtil.isDefined((String)startHour)) {
                if (!eventAgenda.getStartHour().equals(startHour)) continue;
                return eventAgenda.getId();
            }
            return eventAgenda.getId();
        }
        return null;
    }

    private String getName(Component eventIcal, String defaultName) {
        String name = this.getFieldEvent(eventIcal.getProperty("SUMMARY"));
        if (!StringUtil.isDefined((String)name)) {
            name = StringUtil.isDefined((String)defaultName) ? defaultName : " ";
        }
        return name;
    }

    private void processCategories(Component eventIcal, String idEvent) throws AgendaException {
        if (eventIcal.getProperty("CATEGORIES") != null) {
            String categories = eventIcal.getProperty("CATEGORIES").getValue();
            StringTokenizer st = new StringTokenizer(categories, ",");
            String[] categoryIds = new String[st.countTokens()];
            int j = 0;
            boolean addCategoryToEvent = false;
            while (st.hasMoreTokens()) {
                String categIcal = st.nextToken();
                for (Category category : this.agendaSessionController.getAllCategories()) {
                    if (!categIcal.equals(WebEncodeHelper.htmlStringToJavaString((String)category.getName()))) continue;
                    addCategoryToEvent = true;
                    categoryIds[j++] = category.getId();
                }
            }
            if (addCategoryToEvent) {
                this.agendaSessionController.setJournalCategories(idEvent, categoryIds);
            }
        }
    }

    private void setCalendarBm() {
        if (this.calendarService == null) {
            this.calendarService = (SilverpeasCalendar)ServiceProvider.getService(SilverpeasCalendar.class, (Annotation[])new Annotation[0]);
        }
    }

    private Date getDay(String dateTime) throws ParseException {
        Objects.requireNonNull(dateTime);
        Object day = dateTime.length() > 8 ? new DateTime(dateTime) : new Date(dateTime);
        return day;
    }

    private String getHour(String dateTime) throws ParseException {
        Objects.requireNonNull(dateTime);
        String hour = null;
        if (dateTime.length() > 8) {
            hour = DateUtil.getFormattedTime((java.util.Date)new DateTime(dateTime));
        }
        return hour;
    }

    private String getFieldEvent(Property property) {
        String fieldValue = null;
        if (property != null) {
            fieldValue = ImportIcalManager.transformStringForBD(property.getValue());
        }
        return fieldValue;
    }

    private static Collection<Date> getRecurrenceDates(VEvent event) {
        RRule rule = (RRule)event.getProperty("RRULE");
        if (rule != null) {
            Recur recur = rule.getRecur();
            DateTime startDate = new DateTime((java.util.Date)event.getStartDate().getDate());
            long interval = 63072000000L;
            if (Recur.Frequency.YEARLY.equals((Object)recur.getFrequency())) {
                interval *= 5L;
            }
            DateTime endDate = new DateTime(startDate.getTime() + interval);
            return recur.getDates((Date)startDate, (Date)endDate, Value.DATE_TIME);
        }
        return Collections.emptyList();
    }

    public static String transformStringForBD(String sText) {
        if (!StringUtil.isDefined((String)sText)) {
            return "";
        }
        int nStringLength = sText.length();
        StringBuilder resSB = new StringBuilder(nStringLength + 10);
        block4: for (int i = 0; i < nStringLength; ++i) {
            switch (sText.charAt(i)) {
                case '\u20ac': {
                    resSB.append('\u20ac');
                    continue block4;
                }
                case '\u2019': {
                    resSB.append('\'');
                    continue block4;
                }
                default: {
                    resSB.append(sText.charAt(i));
                }
            }
        }
        return resSB.toString();
    }
}

