/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
public class MandatoryQuestionChecker {
    private static final SettingBundle general = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");

    protected MandatoryQuestionChecker() {
    }

    public String check(HttpServletRequest req, String authenticationKey) {
        boolean isUserLoginQuestionMandatory;
        String destination = null;
        boolean bl = isUserLoginQuestionMandatory = "personalQuestion".equals(general.getString("forgottenPwdActive")) && general.getBoolean("userLoginQuestionMandatory", false);
        if (isUserLoginQuestionMandatory) {
            HttpSession session = req.getSession();
            session.setAttribute("svplogin_Key", (Object)authenticationKey);
            try {
                String userId = AdministrationServiceProvider.getAdminService().identify(authenticationKey, session.getId(), false, false);
                UserDetail userDetail = AdministrationServiceProvider.getAdminService().getUserDetail(userId);
                if (userDetail != null && !userDetail.isAnonymous() && !StringUtil.isDefined((String)userDetail.getLoginQuestion())) {
                    req.setAttribute("userDetail", (Object)userDetail);
                    req.setAttribute("userLanguage", (Object)userDetail.getUserPreferences().getLanguage());
                    destination = "/CredentialsServlet/ChangeQuestion";
                }
            }
            catch (AdminException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return destination;
    }
}

