/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mylinks.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.mylinks.dao.LinkCategoryDAO;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class CategoryDAO {
    private static final String CATEGORY_TABLE = "SB_MyLinks_Cat";
    private static final String CAT_ID = "catId";
    private static final String CAT_ID_CLAUSE = "catId = ?";
    private static final String USER_ID_CLAUSE = "userId = ?";

    protected CategoryDAO() {
    }

    public void deleteUserData(String userId) throws SQLException {
        LinkCategoryDAO.get().deleteUserData(userId);
        JdbcSqlQuery.deleteFrom((String)CATEGORY_TABLE).where(USER_ID_CLAUSE, new Object[]{userId}).execute();
    }

    public List<CategoryDetail> getAllCategoriesByUser(String userId) throws SQLException {
        return JdbcSqlQuery.select((String)"*").from(new String[]{CATEGORY_TABLE}).where(USER_ID_CLAUSE, new Object[]{userId}).execute(CategoryDAO::fetchCategory);
    }

    public CategoryDetail getCategory(int id) throws SQLException {
        return (CategoryDetail)JdbcSqlQuery.unique(this.getCategories(Collections.singleton(id)));
    }

    public List<CategoryDetail> getCategories(Collection<Integer> ids) throws SQLException {
        Mutable categories = Mutable.of(Stream.empty());
        JdbcSqlQuery.executeBySplittingOn(ids, (idBatch, ignore) -> categories.set(Stream.concat((Stream)categories.get(), JdbcSqlQuery.select((String)"*").from(new String[]{CATEGORY_TABLE}).where(CAT_ID, new Object[0]).in(idBatch).execute(CategoryDAO::fetchCategory).stream())));
        return ((Stream)categories.get()).collect(Collectors.toList());
    }

    public CategoryDetail create(CategoryDetail category) throws SQLException {
        CategoryDetail categoryToPersist = new CategoryDetail(category);
        categoryToPersist.setId(DBUtil.getNextId((String)CATEGORY_TABLE, (String)CAT_ID));
        categoryToPersist.setHasPosition(false);
        JdbcSqlQuery insertQuery = JdbcSqlQuery.insertInto((String)CATEGORY_TABLE);
        CategoryDAO.setupSaveQuery(insertQuery, categoryToPersist, true).execute();
        return categoryToPersist;
    }

    public CategoryDetail update(CategoryDetail category) throws SQLException {
        CategoryDetail categoryToUpdate = new CategoryDetail(category);
        JdbcSqlQuery updateQuery = JdbcSqlQuery.update((String)CATEGORY_TABLE);
        CategoryDAO.setupSaveQuery(updateQuery, categoryToUpdate, false).execute();
        return categoryToUpdate;
    }

    public void deleteCategory(int id) throws SQLException {
        LinkCategoryDAO.get().deleteByCategory(id);
        JdbcSqlQuery.deleteFrom((String)CATEGORY_TABLE).where(CAT_ID_CLAUSE, new Object[]{id}).execute();
    }

    private static CategoryDetail fetchCategory(ResultSet rs) throws SQLException {
        CategoryDetail category = new CategoryDetail();
        category.setId(rs.getInt(CAT_ID));
        category.setPosition(rs.getInt("position"));
        category.setHasPosition(!rs.wasNull());
        category.setName(rs.getString("name"));
        category.setDescription(rs.getString("description"));
        category.setUserId(rs.getString("userId"));
        return category;
    }

    private static JdbcSqlQuery setupSaveQuery(JdbcSqlQuery saveQuery, CategoryDetail category, boolean isInsert) {
        if (isInsert) {
            saveQuery.withSaveParam(CAT_ID, (Object)category.getId(), true);
        }
        String name = StringUtil.truncate((String)category.getName(), (int)255);
        String description = StringUtil.truncate((String)category.getDescription(), (int)255);
        saveQuery.withSaveParam("name", (Object)name, isInsert).withSaveParam("description", (Object)description, isInsert).withSaveParam("userId", (Object)category.getUserId(), isInsert);
        if (category.hasPosition()) {
            saveQuery.withSaveParam("position", (Object)category.getPosition(), isInsert);
        }
        if (!isInsert) {
            saveQuery.where(CAT_ID_CLAUSE, new Object[]{category.getId()});
        }
        return saveQuery;
    }
}

