/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.rssaggregator.service;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.components.rssaggregator.model.RSSItem;
import org.silverpeas.components.rssaggregator.model.RssAgregatorException;
import org.silverpeas.components.rssaggregator.model.SPChannel;
import org.silverpeas.components.rssaggregator.model.SPChannelPK;
import org.silverpeas.components.rssaggregator.service.RSSService;
import org.silverpeas.components.rssaggregator.service.RssAggregator;
import org.silverpeas.components.rssaggregator.service.RssAggregatorCache;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.HttpUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class DefaultRSSService
implements RSSService {
    @Inject
    private RssAggregator rssAggregator;
    private final RssAggregatorCache cache = RssAggregatorCache.getInstance();

    @Override
    public List<RSSItem> getApplicationItems(String applicationId, boolean aggregateContent) throws RssAgregatorException {
        List<SPChannel> channels = this.getAllChannels(applicationId);
        return this.buildRSSItemList(channels, aggregateContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SPChannel> getAllChannels(String applicationId) throws RssAgregatorException {
        List<SPChannel> channelsFromDB = this.rssAggregator.getChannels(applicationId);
        ArrayList<SPChannel> channels = new ArrayList<SPChannel>();
        for (SPChannel channel : channelsFromDB) {
            SPChannelPK channelPK = new SPChannelPK(channel.getPK().getId(), channel.getPK());
            if (this.cache.isContentNeedToRefresh(channelPK)) {
                try {
                    this.applyFeedTo(channel);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error("Syndication feed fetching error with channel " + String.valueOf((Object)channelPK) + " at " + channel.getUrl(), (Throwable)e);
                }
                finally {
                    this.cache.addChannelToCache(channel);
                }
            } else {
                channel = this.cache.getChannelFromCache(channelPK);
            }
            channels.add(channel);
        }
        return channels;
    }

    private void applyFeedTo(SPChannel channel) throws RssAgregatorException {
        String channelUrl = channel.getUrl();
        if (StringUtil.isDefined((String)channelUrl)) {
            try {
                HttpClient httpClient = channel.isSafeUrl() ? HttpUtil.httpClientTrustingAnySslContext() : HttpUtil.httpClient();
                HttpResponse<InputStream> response = httpClient.send(HttpUtil.toUrl((String)channelUrl).header("Accept", "application/rss+xml").build(), HttpResponse.BodyHandlers.ofInputStream());
                try (InputStream body = response.body();){
                    SyndFeedInput input = new SyndFeedInput();
                    SyndFeed feed = input.build((Reader)new XmlReader(body));
                    channel.setFeed(feed);
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new RssAgregatorException(e.getMessage(), e);
            }
        }
    }

    private List<RSSItem> buildRSSItemList(List<SPChannel> channels, boolean agregateContent) {
        ArrayList<RSSItem> items = new ArrayList<RSSItem>();
        for (SPChannel spChannel : channels) {
            SyndEntry feedEntry;
            SyndFeed feed = spChannel.getFeed();
            if (feed == null) continue;
            List feedEntries = feed.getEntries();
            int itemsCount = spChannel.getNbDisplayedItems();
            Iterator iterator = feedEntries.iterator();
            while (iterator.hasNext() && feedEntries.indexOf(feedEntry = (SyndEntry)iterator.next()) + 1 <= itemsCount) {
                items.add(new RSSItem(feedEntry, feed, spChannel));
            }
        }
        if (agregateContent) {
            Collections.sort(items);
        }
        return items;
    }
}

