/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mylinks.service;

import java.sql.SQLException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.mylinks.MyLinksRuntimeException;
import org.silverpeas.core.mylinks.dao.CategoryDAO;
import org.silverpeas.core.mylinks.dao.LinkDAO;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.mylinks.model.CategoryDetailComparator;
import org.silverpeas.core.mylinks.model.LinkDetail;
import org.silverpeas.core.mylinks.model.LinkDetailComparator;
import org.silverpeas.core.mylinks.service.MyLinksService;

@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultMyLinksService
implements MyLinksService,
ComponentInstanceDeletion {
    @Inject
    private LinkDAO linkDao;
    @Inject
    private CategoryDAO categoryDAO;

    @Transactional
    public void delete(String componentInstanceId) {
        try {
            this.linkDao.deleteComponentInstanceData(componentInstanceId);
        }
        catch (SQLException e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void deleteUserData(String userId) {
        try {
            this.linkDao.deleteUserData(userId);
            this.categoryDAO.deleteUserData(userId);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    public List<CategoryDetail> getAllCategoriesByUser(String userId) {
        try {
            List<CategoryDetail> categories = this.categoryDAO.getAllCategoriesByUser(userId);
            return CategoryDetailComparator.sort(categories);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public CategoryDetail createCategory(CategoryDetail category) {
        try {
            return this.categoryDAO.create(category);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public CategoryDetail getCategory(String categoryId) {
        try {
            return this.categoryDAO.getCategory(Integer.parseInt(categoryId));
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void deleteCategories(String[] categoryIds) {
        try {
            for (String categoryId : categoryIds) {
                this.categoryDAO.deleteCategory(Integer.parseInt(categoryId));
            }
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public CategoryDetail updateCategory(CategoryDetail category) {
        try {
            return this.categoryDAO.update(category);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    public List<LinkDetail> getAllLinks(String userId) {
        return this.getAllLinksByUser(userId);
    }

    @Override
    public List<LinkDetail> getAllLinksByUser(String userId) {
        try {
            List<LinkDetail> links = this.linkDao.getAllLinksByUser(userId);
            return LinkDetailComparator.sort(links);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    public List<LinkDetail> getAllLinksByInstance(String instanceId) {
        try {
            List<LinkDetail> links = this.linkDao.getAllLinksByInstance(instanceId);
            return LinkDetailComparator.sort(links);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    public List<LinkDetail> getAllLinksByObject(String instanceId, String objectId) {
        try {
            List<LinkDetail> links = this.linkDao.getAllLinksByObject(instanceId, objectId);
            return LinkDetailComparator.sort(links);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public LinkDetail createLink(LinkDetail link) {
        try {
            return this.linkDao.createLink(link);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void deleteLinks(String[] links) {
        try {
            for (String linkId : links) {
                this.linkDao.deleteLink(linkId);
            }
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public LinkDetail updateLink(LinkDetail link) {
        try {
            return this.linkDao.updateLink(link);
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }

    @Override
    public LinkDetail getLink(String linkId) {
        try {
            return this.linkDao.getLink(Integer.parseInt(linkId));
        }
        catch (Exception e) {
            throw new MyLinksRuntimeException(e);
        }
    }
}

