/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBEREncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class LDAPBackupRequest
extends LDAPExtendedOperation {
    public LDAPBackupRequest(String objectDN, byte[] passwd, String stateInfo) throws LDAPException {
        super("2.16.840.1.113719.1.27.100.96", null);
        try {
            int revision;
            int mts;
            if (objectDN == null) {
                throw new IllegalArgumentException("PARAM_ERROR");
            }
            if (passwd == null) {
                passwd = "".getBytes("UTF8");
            }
            if (stateInfo == null) {
                mts = 0;
                revision = 0;
            } else {
                int index = (stateInfo = stateInfo.trim()).indexOf(43);
                if (index == -1) {
                    throw new IllegalArgumentException("PARAM_ERROR");
                }
                String mtsStr = stateInfo.substring(0, index);
                String revisionStr = stateInfo.substring(index + 1);
                try {
                    mts = Integer.parseInt(mtsStr);
                }
                catch (NumberFormatException e) {
                    throw new LDAPLocalException("Invalid Modification Timestamp send in the request", 83);
                }
                try {
                    revision = Integer.parseInt(revisionStr);
                }
                catch (NumberFormatException e) {
                    throw new LDAPLocalException("Invalid Revision send in the request", 83);
                }
            }
            ByteArrayOutputStream encodedData = new ByteArrayOutputStream();
            LBEREncoder encoder = new LBEREncoder();
            ASN1OctetString asn1_objectDN = new ASN1OctetString(objectDN);
            ASN1Integer asn1_mts = new ASN1Integer(mts);
            ASN1Integer asn1_revision = new ASN1Integer(revision);
            ASN1OctetString asn1_passwd = new ASN1OctetString(passwd);
            asn1_objectDN.encode(encoder, encodedData);
            asn1_mts.encode(encoder, encodedData);
            asn1_revision.encode(encoder, encodedData);
            asn1_passwd.encode(encoder, encodedData);
            this.setValue(encodedData.toByteArray());
        }
        catch (IOException ioe) {
            throw new LDAPException("ENCODING_ERROR", 83, null);
        }
    }

    static {
        try {
            LDAPExtendedResponse.register("2.16.840.1.113719.1.27.100.97", Class.forName("com.novell.ldap.extensions.LDAPBackupResponse"));
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not register Extended Response - Class not found");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

