/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ModuleStateEventData
implements EventResponseData {
    private final String connectionDN;
    private final int flags;
    private final String name;
    private final String description;
    private final String source;

    public ModuleStateEventData(ASN1Object message) throws IOException {
        byte[] data = ((ASN1OctetString)message).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.connectionDN = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.flags = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.name = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.description = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.source = ((ASN1OctetString)decode.decode(in, length)).stringValue();
    }

    public String getConnectionDN() {
        return this.connectionDN;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ModuleStateEvent[connectionDN=" + this.getConnectionDN() + "]");
        buf.append("[flags=" + this.getFlags() + "]");
        buf.append("[Name=" + this.getName() + "]");
        buf.append("[Description=" + this.getDescription() + "]");
        buf.append("[Source=" + this.getSource() + "]]");
        return buf.toString();
    }
}

