/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.client.ArrayEnumeration;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPAttribute
implements Cloneable,
Comparable,
Externalizable {
    private String name;
    private String baseName;
    private String[] subTypes = null;
    private Object[] values = null;

    public LDAPAttribute() {
    }

    public LDAPAttribute(LDAPAttribute attr) {
        if (attr == null) {
            throw new IllegalArgumentException("LDAPAttribute class cannot be null");
        }
        this.name = attr.name;
        this.baseName = attr.baseName;
        if (null != attr.subTypes) {
            this.subTypes = new String[attr.subTypes.length];
            System.arraycopy(attr.subTypes, 0, this.subTypes, 0, this.subTypes.length);
        }
        if (null != attr.values) {
            this.values = new Object[attr.values.length];
            System.arraycopy(attr.values, 0, this.values, 0, this.values.length);
        }
    }

    public LDAPAttribute(String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        this.name = attrName;
        this.baseName = LDAPAttribute.getBaseName(attrName);
        this.subTypes = LDAPAttribute.getSubtypes(attrName);
    }

    public LDAPAttribute(String attrName, byte[] attrBytes) {
        this(attrName);
        if (attrBytes == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        byte[] tmp = new byte[attrBytes.length];
        System.arraycopy(attrBytes, 0, tmp, 0, attrBytes.length);
        this.add(tmp);
    }

    public LDAPAttribute(String attrName, String attrString) {
        this(attrName);
        if (attrString == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.add(attrString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public LDAPAttribute(String attrName, String[] attrStrings) {
        this(attrName);
        if (attrStrings == null) {
            throw new IllegalArgumentException("Attribute values array cannot be null");
        }
        int u = attrStrings.length;
        for (int i = 0; i < u; ++i) {
            try {
                if (attrStrings[i] == null) {
                    throw new IllegalArgumentException("Attribute value at array index " + i + " cannot be null");
                }
                this.add(attrStrings[i].getBytes("UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    public Object clone() {
        try {
            Object newObj = super.clone();
            if (this.values != null) {
                System.arraycopy(this.values, 0, ((LDAPAttribute)newObj).values, 0, this.values.length);
            }
            return newObj;
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public void addValue(String attrString) {
        if (attrString == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.add(attrString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException(ue.toString());
        }
    }

    public void addValue(byte[] attrBytes) {
        if (attrBytes == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(attrBytes);
    }

    public void addBase64Value(String attrString) {
        if (attrString == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(attrString));
    }

    public void addBase64Value(StringBuffer attrString, int start, int end) {
        if (attrString == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(attrString, start, end));
    }

    public void addBase64Value(char[] attrChars) {
        if (attrChars == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(attrChars));
    }

    public void addURLValue(String url) throws MalformedURLException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Attribute URL cannot be null");
        }
        this.addURLValue(new URL(url));
    }

    public void addURLValue(URL url) throws MalformedURLException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Attribute URL cannot be null");
        }
        try {
            int len;
            InputStream in = url.openStream();
            class URLData {
                private int length;
                private byte[] data;

                URLData(byte[] data, int length) {
                    this.length = length;
                    this.data = data;
                }

                private int getLength() {
                    return this.length;
                }

                private byte[] getData() {
                    return this.data;
                }
            }
            ArrayList<URLData> bufs = new ArrayList<URLData>();
            byte[] buf = new byte[4096];
            int totalLength = 0;
            while ((len = in.read(buf, 0, 4096)) != -1) {
                bufs.add(new URLData(buf, len));
                buf = new byte[4096];
                totalLength += len;
            }
            byte[] data = new byte[totalLength];
            int offset = 0;
            for (int i = 0; i < bufs.size(); ++i) {
                URLData b = (URLData)bufs.get(i);
                len = b.getLength();
                System.arraycopy(b.getData(), 0, data, offset, len);
                offset += len;
            }
            this.add(data);
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException(ue.toString());
        }
    }

    public Enumeration getByteValues() {
        return new ArrayEnumeration((Object[])this.getByteValueArray());
    }

    public Enumeration getStringValues() {
        return new ArrayEnumeration(this.getStringValueArray());
    }

    public byte[][] getByteValueArray() {
        if (null == this.values) {
            return new byte[0][];
        }
        int size = this.values.length;
        byte[][] bva = new byte[size][];
        int u = size;
        for (int i = 0; i < u; ++i) {
            bva[i] = new byte[((byte[])this.values[i]).length];
            System.arraycopy(this.values[i], 0, bva[i], 0, bva[i].length);
        }
        return bva;
    }

    public String[] getStringValueArray() {
        if (null == this.values) {
            return new String[0];
        }
        int size = this.values.length;
        String[] sva = new String[size];
        for (int j = 0; j < size; ++j) {
            try {
                sva[j] = new String((byte[])this.values[j], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee.toString());
            }
        }
        return sva;
    }

    public String getStringValue() {
        String rval = null;
        if (this.values != null) {
            try {
                rval = new String((byte[])this.values[0], "UTF-8");
            }
            catch (UnsupportedEncodingException use) {
                throw new RuntimeException(use.toString());
            }
        }
        return rval;
    }

    public byte[] getByteValue() {
        byte[] bva = null;
        if (this.values != null) {
            bva = new byte[((byte[])this.values[0]).length];
            System.arraycopy(this.values[0], 0, bva, 0, bva.length);
        }
        return bva;
    }

    public String getLangSubtype() {
        if (this.subTypes != null) {
            for (int i = 0; i < this.subTypes.length; ++i) {
                if (!this.subTypes[i].startsWith("lang-")) continue;
                return this.subTypes[i];
            }
        }
        return null;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public static String getBaseName(String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        int idx = attrName.indexOf(59);
        if (-1 == idx) {
            return attrName;
        }
        return attrName.substring(0, idx);
    }

    public String getName() {
        return this.name;
    }

    public String[] getSubtypes() {
        return this.subTypes;
    }

    public static String[] getSubtypes(String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        StringTokenizer st = new StringTokenizer(attrName, ";");
        String[] subTypes = null;
        int cnt = st.countTokens();
        if (cnt > 0) {
            st.nextToken();
            subTypes = new String[cnt - 1];
            int i = 0;
            while (st.hasMoreTokens()) {
                subTypes[i++] = st.nextToken();
            }
        }
        return subTypes;
    }

    public boolean hasSubtype(String subtype) {
        if (subtype == null) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        if (null != this.subTypes) {
            for (int i = 0; i < this.subTypes.length; ++i) {
                if (!this.subTypes[i].equalsIgnoreCase(subtype)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSubtypes(String[] subtypes) {
        if (subtypes == null) {
            throw new IllegalArgumentException("subtypes cannot be null");
        }
        block0: for (int i = 0; i < subtypes.length; ++i) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                if (this.subTypes[j] == null) {
                    throw new IllegalArgumentException("subtype at array index " + i + " cannot be null");
                }
                if (this.subTypes[j].equalsIgnoreCase(subtypes[i])) continue block0;
            }
            return false;
        }
        return true;
    }

    public void removeValue(String attrString) {
        if (null == attrString) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.removeValue(attrString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee.toString());
        }
    }

    public void removeValue(byte[] attrBytes) {
        if (null == attrBytes) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.equals(attrBytes, (byte[])this.values[i])) continue;
            if (0 == i && 1 == this.values.length) {
                this.values = null;
                return;
            }
            if (this.values.length == 1) {
                this.values = null;
                break;
            }
            int moved = this.values.length - i - 1;
            Object[] tmp = new Object[this.values.length - 1];
            if (i != 0) {
                System.arraycopy(this.values, 0, tmp, 0, i);
            }
            if (moved != 0) {
                System.arraycopy(this.values, i + 1, tmp, i, moved);
            }
            this.values = tmp;
            tmp = null;
            break;
        }
    }

    public int size() {
        return null == this.values ? 0 : this.values.length;
    }

    public int compareTo(Object attribute) {
        return this.name.compareTo(((LDAPAttribute)attribute).name);
    }

    private void add(byte[] bytes) {
        if (null == this.values) {
            this.values = new Object[]{bytes};
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.equals(bytes, (byte[])this.values[i])) continue;
                return;
            }
            Object[] tmp = new Object[this.values.length + 1];
            System.arraycopy(this.values, 0, tmp, 0, this.values.length);
            tmp[this.values.length] = bytes;
            this.values = tmp;
            Object var2_3 = null;
        }
    }

    protected void setValue(String value) {
        this.values = null;
        try {
            this.add(value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException(ue.toString());
        }
    }

    private boolean equals(byte[] e1, byte[] e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        int length = e1.length;
        if (e2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (e1[i] == e2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("LDAPAttribute: ");
        try {
            result.append("{type='" + this.name + "'");
            if (this.values != null) {
                result.append(", ");
                if (this.values.length == 1) {
                    result.append("value='");
                } else {
                    result.append("values='");
                }
                for (int i = 0; i < this.values.length; ++i) {
                    if (i != 0) {
                        result.append("','");
                    }
                    if (((byte[])this.values[i]).length == 0) continue;
                    String sval = new String((byte[])this.values[i], "UTF-8");
                    if (sval.length() == 0) {
                        result.append("<binary value, length:" + sval.length());
                        continue;
                    }
                    result.append(sval);
                }
                result.append("'");
            }
            result.append("}");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return result.toString();
    }

    void newLine(int indentTabs, Writer out) throws IOException {
        String tabString = "    ";
        out.write("\n");
        for (int i = 0; i < indentTabs; ++i) {
            out.write(tabString);
        }
    }

    public void writeDSML(OutputStream oout) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(oout, "UTF-8");
        out.write("<LDAPAttribute>");
        this.newLine(1, out);
        out.write("<attr name=\"");
        out.write(this.getName());
        out.write("\">");
        this.writeValue(out);
        this.newLine(1, out);
        out.write("</attr>");
        this.newLine(0, out);
        out.write("</LDAPAttribute>");
        ((Writer)out).close();
    }

    protected void writeValue(Writer out) throws IOException {
        String[] values = this.getStringValueArray();
        byte[][] bytevalues = this.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            this.newLine(2, out);
            if (Base64.isValidUTF8(bytevalues[i], false)) {
                out.write("<value>");
                out.write(values[i]);
                out.write("</value>");
                continue;
            }
            out.write("<value xsi:type=\"xsd:base64Binary\">");
            out.write(Base64.encode(bytevalues[i]));
            out.write("</value>");
        }
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPAttribute.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPAttribute)xmlreader.parseXML(input);
    }

    private static LDAPXMLHandler getTopXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPAttribute)this.valuelist.get(0));
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator valueiterator = this.valuelist.iterator();
                LDAPAttribute attr = new LDAPAttribute(this.attrName);
                while (valueiterator.hasNext()) {
                    attr.addValue((byte[])valueiterator.next());
                }
                this.setObject(attr);
                this.valuelist.clear();
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("value")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String header = "";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n";
        buff.append(header);
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("<LDAPAttribute>");
        buff.append(ValueXMLhandler.newLine(1));
        buff.append("<attr name=\"");
        buff.append(this.getName());
        buff.append("\">");
        this.writeValue(buff);
        buff.append(ValueXMLhandler.newLine(1));
        buff.append("</attr>");
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("</LDAPAttribute>");
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String tail = "";
        tail = tail + "*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        buff.append(tail);
        buff.append(ValueXMLhandler.newLine(0));
        out.writeUTF(buff.toString());
        buff.delete(0, buff.length());
        buff = null;
    }

    protected void writeValue(StringBuffer buff) {
        String[] values = this.getStringValueArray();
        byte[][] bytevalues = this.getByteValueArray();
        for (int i = 0; i < values.length; ++i) {
            buff.append(ValueXMLhandler.newLine(2));
            if (Base64.isValidUTF8(bytevalues[i], false)) {
                buff.append("<value>");
                buff.append(values[i]);
                buff.append("</value>");
                continue;
            }
            buff.append("<value xsi:type=\"xsd:base64Binary\">");
            buff.append(Base64.encode(bytevalues[i]));
            buff.append("</value>");
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String readData = in.readUTF();
        String readProperties = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readProperties, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        this.setDeserializedValues(istream);
        istream.close();
    }

    protected void setDeserializedValues(BufferedInputStream istream) throws IOException {
        LDAPAttribute readObject = (LDAPAttribute)LDAPAttribute.readDSML(istream);
        this.name = readObject.name;
        this.baseName = readObject.baseName;
        if (null != readObject.subTypes) {
            this.subTypes = new String[readObject.subTypes.length];
            System.arraycopy(readObject.subTypes, 0, this.subTypes, 0, this.subTypes.length);
        }
        if (null != readObject.values) {
            this.values = new Object[readObject.values.length];
            System.arraycopy(readObject.values, 0, this.values, 0, this.values.length);
        }
        readObject = null;
    }
}

