/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1SetOf;
import com.novell.ldap.rfc2251.RfcAddRequest;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeList;
import com.novell.ldap.rfc2251.RfcAttributeTypeAndValues;
import com.novell.ldap.rfc2251.RfcAttributeValue;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;

public class LDAPAddRequest
extends LDAPMessage {
    public LDAPAddRequest() {
        super(8);
    }

    public LDAPAddRequest(LDAPEntry entry, LDAPControl[] cont) throws LDAPException {
        super(8, new RfcAddRequest(new RfcLDAPDN(entry.getDN()), LDAPAddRequest.makeRfcAttrList(entry)), cont);
    }

    public LDAPEntry getEntry() {
        RfcAddRequest addreq = (RfcAddRequest)this.getASN1Object().getRequest();
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        ASN1Object[] seqArray = addreq.getAttributes().toArray();
        for (int i = 0; i < seqArray.length; ++i) {
            RfcAttributeTypeAndValues seq = (RfcAttributeTypeAndValues)seqArray[i];
            LDAPAttribute attr = new LDAPAttribute(((ASN1OctetString)seq.get(0)).stringValue());
            ASN1SetOf set = (ASN1SetOf)seq.get(1);
            ASN1Object[] setArray = set.toArray();
            for (int j = 0; j < setArray.length; ++j) {
                attr.addValue(((ASN1OctetString)setArray[j]).byteValue());
            }
            attrs.add(attr);
        }
        return new LDAPEntry(this.getASN1Object().getRequestDN(), attrs);
    }

    private static final RfcAttributeList makeRfcAttrList(LDAPEntry entry) {
        LDAPAttributeSet attrSet = entry.getAttributeSet();
        RfcAttributeList attrList = new RfcAttributeList(attrSet.size());
        Iterator itr = attrSet.iterator();
        while (itr.hasNext()) {
            LDAPAttribute attr = (LDAPAttribute)itr.next();
            ASN1SetOf vals = new ASN1SetOf(attr.size());
            Enumeration attrEnum = attr.getByteValues();
            while (attrEnum.hasMoreElements()) {
                vals.add(new RfcAttributeValue((byte[])attrEnum.nextElement()));
            }
            attrList.add(new RfcAttributeTypeAndValues(new RfcAttributeDescription(attr.getName()), vals));
        }
        return attrList;
    }

    public String toString() {
        return this.getASN1Object().toString();
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPAddRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPAddRequest object");
        }
        LDAPAddRequest tmp = (LDAPAddRequest)readObject;
        LDAPEntry entry = tmp.getEntry();
        tmp = null;
        RfcAddRequest operation = new RfcAddRequest(new RfcLDAPDN(entry.getDN()), LDAPAddRequest.makeRfcAttrList(entry));
        this.message = new RfcLDAPMessage(operation, asn1Ctrls);
        readObject = null;
    }
}

