/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public enum AccessControlOperation {
    UNKNOWN,
    CREATION,
    MODIFICATION,
    DELETION,
    DOWNLOAD,
    SHARING,
    SEARCH;

    static final Set<AccessControlOperation> PERSIST_ACTIONS;

    @JsonValue
    public String getName() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static AccessControlOperation from(String name) {
        try {
            return AccessControlOperation.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            SilverLogger.getLogger(AccessControlOperation.class).warn(SilverpeasExceptionMessages.unknown("access control operation", name), new Object[]{e});
            return UNKNOWN;
        }
    }

    public static boolean isPersistActionFrom(Collection<AccessControlOperation> accessControlOperations) {
        return CollectionUtil.isNotEmpty(accessControlOperations) && !CollectionUtil.intersection(PERSIST_ACTIONS, accessControlOperations).isEmpty();
    }

    public static boolean isSharingActionFrom(Collection<AccessControlOperation> accessControlOperations) {
        return CollectionUtil.isNotEmpty(accessControlOperations) && accessControlOperations.contains((Object)SHARING);
    }

    public static boolean isDownloadActionFrom(Collection<AccessControlOperation> accessControlOperations) {
        return CollectionUtil.isNotEmpty(accessControlOperations) && accessControlOperations.contains((Object)DOWNLOAD);
    }

    public static boolean isSearchActionFrom(Collection<AccessControlOperation> accessControlOperations) {
        return CollectionUtil.isNotEmpty(accessControlOperations) && accessControlOperations.contains((Object)SEARCH);
    }

    static {
        PERSIST_ACTIONS = EnumSet.of(CREATION, MODIFICATION, DELETION);
    }
}

