/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.PersistOperation;
import org.silverpeas.core.persistence.datasource.PersistenceOperation;
import org.silverpeas.core.persistence.datasource.model.Entity;
import org.silverpeas.core.persistence.datasource.model.jpa.JPA;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.core.util.ArgumentAssertion;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@PersistOperation
@Technical
@JPA
@Bean
public class JpaPersistOperation
extends PersistenceOperation {
    private final List<SilverpeasJpaEntity<?, ?>> entities = new ArrayList();

    @Override
    protected void applyTechnicalDataTo(Entity<?, ?> entity) {
        String errorMessage = "the user identifier must exist when performing persist operation";
        User user = OperationContext.getFromCache().getUser();
        ArgumentAssertion.assertTrue(Transaction.isTransactionActive(), "A transaction must be active when performing persist operation");
        ArgumentAssertion.assertNotNull(user, errorMessage);
        ArgumentAssertion.assertDefined(user.getId(), errorMessage);
        if (entity instanceof SilverpeasJpaEntity) {
            SilverpeasJpaEntity jpaEntity = (SilverpeasJpaEntity)entity;
            Optional<SilverpeasJpaEntity<?, ?>> optional = this.find(jpaEntity);
            if (optional.isPresent()) {
                if (optional.get() != jpaEntity) {
                    jpaEntity.setCreator(optional.get().getCreator()).setCreationDate(optional.get().getCreationDate());
                }
                if (jpaEntity.getLastUpdater() != null && jpaEntity.getLastUpdateDate() != null) {
                    jpaEntity.setLastUpdater(optional.get().getLastUpdater()).setLastUpdateDate(optional.get().getLastUpdateDate());
                } else {
                    jpaEntity.setLastUpdater(optional.get().getCreator()).setLastUpdateDate(optional.get().getCreationDate());
                }
            } else {
                Timestamp now = new Timestamp(new Date().getTime());
                jpaEntity.setCreator(user).setCreationDate(now);
                jpaEntity.setLastUpdater(user).setLastUpdateDate(now);
            }
        } else {
            Timestamp now = new Timestamp(new Date().getTime());
            entity.createdBy(user, now);
            entity.updatedBy(user, now);
        }
    }

    @Override
    public void setManuallyTechnicalDataFor(Entity<?, ?> entity, User creator, Date creationDate) {
        if (entity instanceof SilverpeasJpaEntity) {
            SilverpeasJpaEntity jpaEntity = (SilverpeasJpaEntity)entity;
            jpaEntity.setCreator(creator).setCreationDate(creationDate);
            if (this.find(jpaEntity).isEmpty()) {
                this.entities.add(jpaEntity);
            }
        }
    }

    private Optional<SilverpeasJpaEntity<?, ?>> find(Entity<?, ?> entity) {
        return this.entities.stream().filter(e -> e.equals(entity)).findFirst();
    }

    @Override
    public void clear(Entity<?, ?> entity) {
        if (!StringUtil.isDefined((String)entity.getId())) {
            this.entities.removeIf(e -> e.getClass().equals(entity.getClass()) && StringUtil.isDefined((String)e.getId()));
        }
    }
}

