/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.system;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.notification.system.StateTransition;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractResourceEvent<T extends Serializable>
implements ResourceEvent<T> {
    private static final long serialVersionUID = 8036157397157376709L;
    @XmlElement
    private ResourceEvent.Type type;
    @XmlElement
    private StateTransition<T> transition;
    @XmlElement
    private Map<String, String> parameters = new HashMap<String, String>();

    protected AbstractResourceEvent() {
    }

    @SafeVarargs
    protected AbstractResourceEvent(ResourceEvent.Type type, T ... resource) {
        this.type = type;
        if (type == ResourceEvent.Type.CREATION) {
            this.transition = StateTransition.transitionBetween(null, resource[0]);
        } else if (type == ResourceEvent.Type.UNLOCK || type == ResourceEvent.Type.UPDATE || type == ResourceEvent.Type.MOVE) {
            this.transition = StateTransition.transitionBetween(resource[0], resource[1]);
        } else if (type == ResourceEvent.Type.REMOVING || type == ResourceEvent.Type.RECOVERY) {
            this.transition = StateTransition.transitionBetween(resource[0], resource[0]);
        } else if (type == ResourceEvent.Type.DELETION) {
            this.transition = StateTransition.transitionBetween(resource[0], null);
        }
    }

    @Override
    public ResourceEvent.Type getType() {
        return this.type;
    }

    @Override
    public StateTransition<T> getTransition() {
        return this.transition;
    }

    public void putParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getParameterValue(String name) {
        return this.parameters.get(name);
    }

    public Set<String> getParameters() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractResourceEvent that = (AbstractResourceEvent)o;
        return this.transition.equals(that.transition) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.transition});
    }
}

