/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;

@Embeddable
public class CategorySet
implements Serializable {
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="sb_cal_categories", joinColumns={@JoinColumn(name="id")})
    @Column(name="category")
    private Set<String> categories = new HashSet<String>();

    public void add(String categoryId) {
        this.categories.add(categoryId);
    }

    public void addAll(List<String> categoryIds) {
        this.categories.addAll(categoryIds);
    }

    public void addAll(String ... categoryIds) {
        this.addAll(Arrays.asList(categoryIds));
    }

    public void remove(String categoryId) {
        this.categories.remove(categoryId);
    }

    public void removeAll(List<String> categoryIds) {
        this.categories.removeAll(categoryIds);
    }

    public void remove(String ... categoryIds) {
        this.removeAll(Arrays.asList(categoryIds));
    }

    public List<String> asList() {
        return new ArrayList<String>(this.categories);
    }

    public String[] asArray() {
        List<String> categoryList = this.asList();
        return categoryList.toArray(new String[categoryList.size()]);
    }

    public boolean contains(String category) {
        return this.categories.contains(category);
    }

    public boolean isEmpty() {
        return this.categories.isEmpty();
    }

    public Stream<String> stream() {
        return this.categories.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategorySet)) {
            return false;
        }
        CategorySet that = (CategorySet)o;
        return this.categories.equals(that.categories);
    }

    public int hashCode() {
        return this.categories.hashCode();
    }

    public void addAllFrom(CategorySet categories) {
        this.categories.addAll(categories.categories);
    }

    public CategorySet copy() {
        CategorySet copy = new CategorySet();
        copy.categories = new HashSet<String>(this.categories);
        return copy;
    }
}

