/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.security.Principal;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.permission.AllPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissionImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStoreImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionProviderImpl
implements PermissionProvider,
AccessControlConstants,
PermissionConstants,
AggregatedPermissionProvider {
    private final Root root;
    private final String workspaceName;
    private final Set<Principal> principals;
    private final RestrictionProvider restrictionProvider;
    private final ConfigurationParameters options;
    private final Context ctx;
    private final ProviderCtx providerCtx;
    private CompiledPermissions compiledPermissions;
    private Root immutableRoot;

    public PermissionProviderImpl(@NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull RestrictionProvider restrictionProvider, @NotNull ConfigurationParameters options, @NotNull Context ctx, @NotNull ProviderCtx providerCtx) {
        this.root = root;
        this.workspaceName = workspaceName;
        this.principals = principals;
        this.restrictionProvider = restrictionProvider;
        this.options = options;
        this.ctx = ctx;
        this.providerCtx = providerCtx;
        this.immutableRoot = providerCtx.getRootProvider().createReadOnlyRoot(root);
    }

    public void refresh() {
        this.immutableRoot = this.providerCtx.getRootProvider().createReadOnlyRoot(this.root);
        this.getCompiledPermissions().refresh(this.immutableRoot, this.workspaceName);
        this.providerCtx.getMonitor().permissionRefresh();
    }

    @NotNull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        return this.getCompiledPermissions().getPrivileges(PermissionUtil.getReadOnlyTreeOrNull(tree, this.immutableRoot));
    }

    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return this.getCompiledPermissions().hasPrivileges(PermissionUtil.getReadOnlyTreeOrNull(tree, this.immutableRoot), privilegeNames);
    }

    @NotNull
    public RepositoryPermission getRepositoryPermission() {
        return this.getCompiledPermissions().getRepositoryPermission();
    }

    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreePermission parentPermission) {
        return this.getCompiledPermissions().getTreePermission(PermissionUtil.getReadOnlyTree(tree, this.immutableRoot), parentPermission);
    }

    public boolean isGranted(@NotNull Tree tree, @Nullable PropertyState property, long permissions) {
        return this.getCompiledPermissions().isGranted(PermissionUtil.getReadOnlyTree(tree, this.immutableRoot), property, permissions);
    }

    public boolean isGranted(@NotNull String oakPath, @NotNull String jcrActions) {
        TreeLocation location = TreeLocation.create((Root)this.immutableRoot, (String)oakPath);
        boolean isAcContent = this.ctx.definesLocation(location);
        long permissions = Permissions.getPermissions((String)jcrActions, (TreeLocation)location, (boolean)isAcContent);
        return this.isGranted(location, oakPath, permissions);
    }

    @NotNull
    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        return privilegeBits != null ? privilegeBits : new PrivilegeBitsProvider(this.immutableRoot).getBits(new String[]{"jcr:all"});
    }

    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        return permissions;
    }

    public long supportedPermissions(@NotNull TreeLocation location, long permissions) {
        return permissions;
    }

    public long supportedPermissions(@NotNull TreePermission treePermission, @Nullable PropertyState property, long permissions) {
        return permissions;
    }

    public boolean isGranted(@NotNull TreeLocation location, long permissions) {
        return this.isGranted(location, location.getPath(), permissions);
    }

    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreePermission parentPermission) {
        return this.getCompiledPermissions().getTreePermission(PermissionUtil.getReadOnlyTree(tree, this.immutableRoot), type, parentPermission);
    }

    private CompiledPermissions getCompiledPermissions() {
        CompiledPermissions cp = this.compiledPermissions;
        if (cp == null) {
            cp = PermissionUtil.isAdminOrSystem(this.principals, this.options) ? AllPermissions.getInstance() : CompiledPermissionImpl.create(this.immutableRoot, this.workspaceName, this.getPermissionStore(this.immutableRoot, this.workspaceName, this.restrictionProvider), this.principals, this.options, this.ctx, this.providerCtx);
            this.compiledPermissions = cp;
        }
        return cp;
    }

    @NotNull
    protected PermissionStore getPermissionStore(@NotNull Root root, @NotNull String workspaceName, @NotNull RestrictionProvider restrictionProvider) {
        return new PermissionStoreImpl(root, workspaceName, restrictionProvider, this.providerCtx.getMonitor());
    }

    private static boolean isVersionStorePath(@NotNull String oakPath) {
        return oakPath.startsWith("/jcr:system/jcr:versionStorage");
    }

    private boolean isGranted(@NotNull TreeLocation location, @NotNull String oakPath, long permissions) {
        Tree tree;
        boolean isGranted = false;
        PropertyState property = location.getProperty();
        Tree tree2 = tree = property == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            isGranted = this.isGranted(tree, property, permissions);
        } else if (!PermissionProviderImpl.isVersionStorePath(location.getPath())) {
            isGranted = this.getCompiledPermissions().isGranted(oakPath, permissions);
        }
        return isGranted;
    }
}

