/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import java.util.Objects;
import org.apache.jackrabbit.oak.plugins.observation.FilteringAwareObserver;
import org.apache.jackrabbit.oak.plugins.observation.FilteringObserver;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class FilteringDispatcher
implements Observer {
    private final FilteringAwareObserver observer;
    private NodeState before;

    public FilteringDispatcher(FilteringAwareObserver observer) {
        this.observer = Objects.requireNonNull(observer);
    }

    public void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        if (this.before != null && info != FilteringObserver.NOOP_CHANGE) {
            this.observer.contentChanged(this.before, root, info);
        }
        this.before = root;
    }
}

