/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.PathCursor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.jetbrains.annotations.Nullable;

class AncestorCursor
extends PathCursor {
    public AncestorCursor(Cursor cursor, int level, QueryLimits settings) {
        super(AncestorCursor.transform(cursor, level), true, settings);
    }

    private static Iterator<String> transform(Cursor cursor, final int level) {
        Iterator unfiltered = IteratorUtils.transform((Iterator)cursor, input -> input != null ? input.getPath() : null);
        Iterator filtered = IteratorUtils.filter((Iterator)unfiltered, (new Predicate<String>(){

            @Override
            public boolean test(@Nullable String input) {
                return input != null && PathUtils.getDepth((String)input) >= level;
            }
        })::test);
        return IteratorUtils.transform((Iterator)filtered, input -> PathUtils.getAncestorPath((String)input, (int)level));
    }
}

