/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.Actions;
import org.silverpeas.core.workflow.engine.model.ActionImpl;

@XmlRootElement(name="actions")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ActionsImpl
implements Serializable,
Actions {
    private static final long serialVersionUID = -8221333788348737417L;
    @XmlElement(name="action", type=ActionImpl.class)
    private List<Action> actionList = new ArrayList<Action>();

    @Override
    public void addAction(Action action) {
        this.actionList.add(action);
    }

    @Override
    public Action createAction() {
        return new ActionImpl();
    }

    @Override
    public Action getAction(String name) throws WorkflowException {
        for (Action action : this.actionList) {
            if (action == null || !action.getName().equals(name)) continue;
            return action;
        }
        throw new WorkflowException("ActionsImpl.getAction(String)", "WorkflowEngine.EX_ERR_ACTION_NOT_FOUND_IN_MODEL", name);
    }

    @Override
    public Action[] getActions() {
        if (this.actionList == null) {
            return new Action[0];
        }
        return this.actionList.toArray(new Action[0]);
    }

    @Override
    public Iterator<Action> iterateAction() {
        return this.actionList.iterator();
    }

    @Override
    public void removeAction(String strActionName) {
        if (this.actionList == null) {
            return;
        }
        this.actionList.removeIf(action -> action.getName().equals(strActionName));
    }
}

