/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.datarecord;

import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceFieldTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceTemplate;

public abstract class AbstractProcessInstanceDataRecord
implements DataRecord {
    private static final long serialVersionUID = 1L;
    protected final Field[] fields;
    protected final ProcessInstance instance;
    protected final ProcessInstanceTemplate template;

    public AbstractProcessInstanceDataRecord(ProcessInstance instance, String role, String lang) throws WorkflowException {
        this.instance = instance;
        this.template = this.getTemplate(role, lang);
        this.fields = this.template != null ? this.template.buildFieldsArray() : new Field[0];
    }

    protected abstract ProcessInstanceTemplate getTemplate(String var1, String var2) throws WorkflowException;

    public String getId() {
        return null;
    }

    public void setId(String externalId) {
    }

    public boolean isNew() {
        return true;
    }

    public Field getField(String fieldName) throws FormException {
        return null;
    }

    public Field getField(String fieldName, int occurrence) {
        return null;
    }

    public Field getField(int fieldIndex) throws FormException {
        Field field = this.fields[fieldIndex];
        if (field == null) {
            ProcessInstanceFieldTemplate fieldTemplate = (ProcessInstanceFieldTemplate)this.template.getFieldTemplate(fieldIndex);
            this.fields[fieldIndex] = field = fieldTemplate.getField(this.instance);
        }
        return field;
    }

    public int size() {
        return this.fields.length;
    }

    public String[] getFieldNames() {
        return new String[0];
    }

    public String getLanguage() {
        return null;
    }

    public void setLanguage(String lang) {
    }

    public Map<String, String> getValues(String language) {
        return new HashMap<String, String>();
    }

    public ResourceReference getResourceReference() {
        return null;
    }
}

