/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import java.lang.annotation.Annotation;
import java.time.temporal.Temporal;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.reminder.BackgroundReminderProcess;
import org.silverpeas.core.reminder.DateTimeReminder;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderProcessName;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

@Named(value="KmeliaDelayedVisibilityUserNotificationReminderProcess")
@Singleton
public class KmeliaDelayedVisibilityUserNotificationReminder
implements BackgroundReminderProcess {
    static final String PROCESS_NAME = "KmeliaDelayedVisibilityUserNotification";
    public static final ReminderProcessName KMELIA_DELAYED_VISIBILITY_USER_NOTIFICATION = () -> "KmeliaDelayedVisibilityUserNotification";
    @Inject
    private KmeliaService kmeliaService;

    public static KmeliaDelayedVisibilityUserNotificationReminder get() {
        return (KmeliaDelayedVisibilityUserNotificationReminder)ServiceProvider.getService(KmeliaDelayedVisibilityUserNotificationReminder.class, (Annotation[])new Annotation[0]);
    }

    public ReminderProcessName getName() {
        return KMELIA_DELAYED_VISIBILITY_USER_NOTIFICATION;
    }

    public void performWith(Reminder reminder) {
        this.kmeliaService.performReminder(reminder);
    }

    public boolean setAbout(PublicationDetail pubDetail) {
        ContributionIdentifier contributionId;
        Temporal delayedVisibilityTemporal = (Temporal)pubDetail.getModel().getProperty("DELAYED_VISIBILITY_AT", new Object[0]);
        if (delayedVisibilityTemporal != null && Reminder.getByContribution((ContributionIdentifier)(contributionId = pubDetail.getIdentifier())).stream().noneMatch(r -> KMELIA_DELAYED_VISIBILITY_USER_NOTIFICATION.asString().equals(r.getProcessName()))) {
            try {
                new DateTimeReminder(contributionId, KMELIA_DELAYED_VISIBILITY_USER_NOTIFICATION).triggerFrom("DELAYED_VISIBILITY_AT").schedule();
                return true;
            }
            catch (SilverpeasRuntimeException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return false;
    }
}

