/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.reminder;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import java.time.OffsetDateTime;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.reminder.DateTimeReminder;
import org.silverpeas.core.reminder.DurationReminder;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.web.rs.WebEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ReminderEntity
implements WebEntity {
    private static final long serialVersionUID = -6481988671227188535L;
    private URI uri;
    private String id;
    private String cId;
    private String cProperty;
    private String userId;
    private String processName;
    private String dateTime;
    private Integer duration;
    private TimeUnit timeUnit;
    private String text;
    private boolean canBeModified;
    private boolean canBeDeleted;

    protected ReminderEntity() {
    }

    public static ReminderEntity fromReminder(Reminder reminder) {
        return new ReminderEntity().decorate(reminder);
    }

    public ReminderEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    protected void setUri(URI uri) {
        this.withURI(uri);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getcId() {
        return this.cId;
    }

    public void setcId(String cId) {
        this.cId = cId;
    }

    public String getcProperty() {
        return this.cProperty;
    }

    public void setcProperty(String cProperty) {
        this.cProperty = cProperty;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @XmlElement
    public boolean canBeModified() {
        return this.canBeModified;
    }

    @XmlElement
    public boolean canBeDeleted() {
        return this.canBeDeleted;
    }

    protected <T extends ReminderEntity> T decorate(Reminder reminder) {
        this.id = reminder.getId();
        this.cId = reminder.getContributionId().asString();
        this.userId = reminder.getUserId();
        this.processName = reminder.getProcessName();
        if (reminder instanceof DateTimeReminder) {
            DateTimeReminder dateTimeReminder = (DateTimeReminder)reminder;
            this.dateTime = dateTimeReminder.getDateTime().toString();
        } else {
            DurationReminder durationReminder = (DurationReminder)reminder;
            this.cProperty = durationReminder.getContributionProperty();
            this.duration = durationReminder.getDuration();
            this.timeUnit = durationReminder.getTimeUnit();
        }
        this.text = reminder.getText();
        this.canBeModified = true;
        this.canBeDeleted = true;
        return (T)this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("uri", (Object)this.getURI());
        builder.append("id", (Object)this.getId());
        builder.append("contributionId", (Object)this.getcId());
        builder.append("contributionProperty", (Object)this.getcProperty());
        builder.append("userId", (Object)this.getUserId());
        builder.append("processName", (Object)this.getProcessName());
        builder.append("dateTime", (Object)this.getDateTime());
        builder.append("duration", (Object)this.getDuration());
        builder.append("timeUnit", (Object)this.getTimeUnit());
        builder.append("text", (Object)this.getText());
        return builder.toString();
    }

    public Reminder mergeInto(Reminder reminder) {
        reminder.withText(this.getText());
        if (reminder instanceof DateTimeReminder) {
            DateTimeReminder dateTimeReminder = (DateTimeReminder)reminder;
            dateTimeReminder.triggerAt(OffsetDateTime.parse(this.getDateTime()));
        } else {
            DurationReminder durationReminder = (DurationReminder)reminder;
            durationReminder.triggerBefore(this.getDuration().intValue(), this.getTimeUnit(), this.getcProperty());
        }
        return reminder;
    }
}

