/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.rating;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.rating.model.ContributionRating;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.model.RaterRating;
import org.silverpeas.core.contribution.rating.model.RaterRatingPK;
import org.silverpeas.core.contribution.rating.service.RatingService;
import org.silverpeas.core.notification.message.MessageNotifier;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.rating.RaterRatingEntity;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="rating/{componentId}/{contributionType}/{contributionId}")
@Authorized
public class RatingResource
extends RESTWebService {
    static final String PATH = "rating";
    @PathParam(value="componentId")
    private String componentId;
    @PathParam(value="contributionType")
    private String contributionType;
    @PathParam(value="contributionId")
    private String contributionId;

    protected String getBundleLocation() {
        return "org.silverpeas.notation.multilang.notation";
    }

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.componentId;
    }

    @GET
    @Produces(value={"application/json"})
    public RaterRatingEntity getRaterRating() {
        try {
            ContributionRating contributionRating = RatingService.get().getRating(this.getRatingPK());
            return this.asWebEntity(contributionRating.getRaterRating(UserDetail.from((User)this.getUser())));
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response saveRating(String note) {
        RatingService ratingService = RatingService.get();
        if (!StringUtil.isDefined((String)note)) {
            ratingService.deleteRaterRating(this.getRaterRatingPK());
            MessageNotifier.addSuccess((String)this.getBundle().getString("notation.vote.delete.ok"), (Object[])new Object[0]);
        } else {
            ratingService.updateRating(this.getRaterRatingPK(), Integer.parseInt(note));
            MessageNotifier.addSuccess((String)this.getBundle().getString("notation.vote.ok"), (Object[])new Object[0]);
        }
        RaterRatingEntity newRating = this.getRaterRating();
        return Response.ok((Object)newRating).build();
    }

    private ContributionRatingPK getRatingPK() {
        return new ContributionRatingPK(this.contributionId, this.componentId, this.contributionType);
    }

    private RaterRatingPK getRaterRatingPK() {
        return new RaterRatingPK(this.contributionId, this.componentId, this.contributionType, UserDetail.from((User)this.getUser()));
    }

    protected RaterRatingEntity asWebEntity(RaterRating raterRating) {
        return RaterRatingEntity.fromRaterRating(raterRating);
    }
}

