/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.publication;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.SharingContext;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateImpl;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.attachment.AttachmentEntity;
import org.silverpeas.core.webapi.profile.UserProfileEntity;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class PublicationEntity
implements WebEntity {
    private static final long serialVersionUID = 7746081841765736096L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private String id;
    @XmlElement(required=true)
    @NotNull
    @Size(min=2)
    private @NotNull @Size(min=2) String componentId;
    @XmlElement(defaultValue="")
    private String name;
    @XmlElement(defaultValue="")
    private String description;
    @XmlElement(defaultValue="")
    private String keywords;
    @XmlElement(defaultValue="0")
    private int importance = 0;
    @XmlElement
    private Date updateDate;
    @XmlElement
    private List<AttachmentEntity> attachments;
    @XmlElement
    private UserProfileEntity creator;
    @XmlElement
    private UserProfileEntity lastUpdater;
    private PublicationDetail pubDetail;
    @XmlElement
    private String content;

    public URI getURI() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public String getComponentId() {
        return this.componentId;
    }

    private PublicationEntity() {
    }

    public static PublicationEntity fromPublicationDetail(PublicationDetail publication, URI uri) {
        return new PublicationEntity(publication, uri);
    }

    private PublicationEntity(PublicationDetail publication, URI uri) {
        this.componentId = publication.getPK().getInstanceId();
        this.id = publication.getPK().getId();
        this.setName(Encode.forHtml((String)publication.getName()));
        this.setDescription(Encode.forHtml((String)publication.getDescription()));
        this.setKeywords(Encode.forHtml((String)publication.getKeywords()));
        this.importance = publication.getImportance();
        this.pubDetail = publication;
        this.setUri(uri);
        this.setUpdateDate(publication.getLastUpdateDate());
        this.creator = UserProfileEntity.fromUser((User)((UserDetail)publication.getCreator()));
        if (StringUtil.isDefined((String)publication.getUpdaterId())) {
            this.lastUpdater = UserProfileEntity.fromUser((User)UserDetail.getById((String)publication.getUpdaterId()));
        }
    }

    public PublicationEntity withAttachments(Collection<SimpleDocument> attachmentDetails) {
        if (attachmentDetails != null && !attachmentDetails.isEmpty()) {
            ArrayList<AttachmentEntity> entities = new ArrayList<AttachmentEntity>(attachmentDetails.size());
            for (SimpleDocument attachment : attachmentDetails) {
                SimpleDocument document = attachment.getLastPublicVersion();
                if (document == null) continue;
                AttachmentEntity entity = AttachmentEntity.fromAttachment(document);
                entities.add(entity);
            }
            this.setAttachments(entities);
        }
        return this;
    }

    public PublicationEntity withSharedContent(SharingContext context) {
        String lang = null;
        if (WysiwygController.haveGotWysiwygToDisplay((String)this.pubDetail.getInstanceId(), (String)this.pubDetail.getId(), lang)) {
            this.content = WysiwygController.load((String)this.pubDetail.getInstanceId(), (String)this.pubDetail.getId(), lang);
            this.content = context.applyOn(this.content);
        } else if (!StringUtil.isInteger((String)this.pubDetail.getInfoId())) {
            try {
                PublicationTemplateImpl pubTemplate = (PublicationTemplateImpl)PublicationTemplateManager.getInstance().getPublicationTemplate(this.pubDetail.getPK().getInstanceId() + ":" + this.pubDetail.getInfoId());
                Form formView = pubTemplate.getViewForm();
                RecordSet recordSet = pubTemplate.getRecordSet();
                DataRecord data = recordSet.getRecord(this.pubDetail.getId(), lang);
                if (data != null) {
                    PagesContext formContext = new PagesContext();
                    formContext.setComponentId(this.pubDetail.getInstanceId());
                    formContext.setObjectId(this.pubDetail.getId());
                    formContext.setBorderPrinted(false);
                    formContext.setSharingContext(context);
                    this.content = formView.toString(formContext, data);
                }
            }
            catch (Exception e) {
                this.content = "Error while getting content !";
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
        return this;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public int getImportance() {
        return this.importance;
    }

    public void setImportance(int importance) {
        this.importance = importance;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setCreator(UserDetail user) {
        this.creator = UserProfileEntity.fromUser((User)user);
    }

    protected void setAttachments(List<AttachmentEntity> attachments) {
        this.attachments = attachments;
    }

    protected List<AttachmentEntity> getAttachments() {
        return this.attachments;
    }

    public PublicationDetail toPublicationDetail() {
        PublicationDetail publication = PublicationDetail.builder().setPk(new PublicationPK(this.id, this.componentId)).setNameAndDescription(this.name, this.description).setKeywords(this.keywords).setImportance(this.importance).build();
        publication.setCreatorId(this.creator.getId());
        if (this.lastUpdater != null) {
            publication.setUpdaterId(this.lastUpdater.getId());
        }
        publication.setUpdateDate(this.updateDate);
        return publication;
    }
}

