/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.profile;

import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.kernel.util.StringUtil;

public class UserGroupsSearchCriteriaBuilder {
    private final GroupsSearchCriteria searchCriteria = new GroupsSearchCriteria();
    private String domainId = null;
    private boolean withMixedDomain = false;

    public static UserGroupsSearchCriteriaBuilder aSearchCriteria() {
        return new UserGroupsSearchCriteriaBuilder();
    }

    public UserGroupsSearchCriteriaBuilder withName(String name) {
        if (StringUtil.isDefined((String)name)) {
            String filterByName = name.replace('*', '%');
            this.searchCriteria.onName(filterByName);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withComponentInstanceId(String instanceId) {
        if (StringUtil.isDefined((String)instanceId)) {
            this.searchCriteria.onComponentInstanceId(instanceId);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withChildren() {
        this.searchCriteria.withChildren();
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withResourceId(String resourceId) {
        if (StringUtil.isDefined((String)resourceId)) {
            this.searchCriteria.onResourceId(resourceId);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withRoles(String[] roleIds, boolean matchingAllRoles) {
        if (roleIds != null && roleIds.length > 0) {
            this.searchCriteria.onRoleNames(roleIds);
            if (matchingAllRoles) {
                this.searchCriteria.matchingAllRoleNames();
            }
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withGroupId(String groupId) {
        if (StringUtil.isDefined((String)groupId)) {
            if (groupId.equals("all")) {
                this.searchCriteria.onGroupIds(UserDetailsSearchCriteria.ANY_GROUPS);
            } else {
                this.searchCriteria.onGroupIds(new String[]{groupId});
            }
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withGroupIds(String[] groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            this.searchCriteria.onGroupIds(groupIds);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withSuperGroupId(String groupId) {
        if (StringUtil.isDefined((String)groupId)) {
            this.searchCriteria.onSuperGroupId(groupId);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withRootGroupSet() {
        this.searchCriteria.onAsRootGroup();
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withDomainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withMixedDomainId() {
        this.withMixedDomain = true;
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withUserIds(String[] userIds) {
        if (userIds != null && userIds.length > 0) {
            this.searchCriteria.onUserIds(userIds);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withUserStatesToExclude(UserState[] userStates) {
        if (userStates != null && userStates.length > 0) {
            this.searchCriteria.onUserStatesToExclude(userStates);
        }
        return this;
    }

    public UserGroupsSearchCriteriaBuilder withPaginationPage(PaginationPage page) {
        this.searchCriteria.onPagination(page);
        return this;
    }

    public GroupsSearchCriteria build() {
        if (this.withMixedDomain) {
            this.searchCriteria.onMixedDomainOrOnDomainId(this.domainId);
        } else if (StringUtil.isDefined((String)this.domainId)) {
            this.searchCriteria.onDomainIds(new String[]{this.domainId});
        }
        return this.searchCriteria;
    }

    private UserGroupsSearchCriteriaBuilder() {
    }
}

