/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.profile;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.profile.UserGroupProfileEntity;
import org.silverpeas.core.webapi.profile.UserGroupsSearchCriteriaBuilder;
import org.silverpeas.core.webapi.profile.UserProfileService;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="profile/groups")
@Authorized
public class UserGroupProfileResource
extends RESTWebService {
    public static final String RESPONSE_HEADER_GROUPSIZE = "X-Silverpeas-GroupSize";
    @Inject
    private UserProfileService profileService;

    @GET
    @Produces(value={"application/json"})
    public Response getAllRootGroups(@QueryParam(value="ids") Set<String> groupIds, @QueryParam(value="withChildren") boolean withChildren, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="domain") String domain, @QueryParam(value="userStatesToExclude") Set<UserState> userStatesToExclude) {
        String domainId;
        UserGroupsSearchCriteriaBuilder criteriaBuilder = UserGroupsSearchCriteriaBuilder.aSearchCriteria();
        if (CollectionUtil.isNotEmpty(groupIds)) {
            criteriaBuilder.withGroupIds(groupIds.toArray(new String[0]));
        } else if (!withChildren) {
            criteriaBuilder.withRootGroupSet();
        }
        String string = domainId = "-1".equals(domain) ? null : domain;
        if (this.getUser().isDomainRestricted()) {
            domainId = this.getUser().getDomainId();
            criteriaBuilder.withMixedDomainId();
        }
        this.userStateFilter(criteriaBuilder, userStatesToExclude);
        criteriaBuilder.withDomainId(domainId).withName(name).withPaginationPage(this.fromPage(page));
        SilverpeasList allGroups = this.getOrganisationController().searchGroups(criteriaBuilder.build(), true);
        UserGroupProfileEntity[] entities = this.asWebEntity((List<? extends Group>)allGroups, UserGroupProfileResource.locatedAt(this.getUri().getAbsolutePath()));
        return Response.ok((Object)entities).header(RESPONSE_HEADER_GROUPSIZE, (Object)allGroups.originalListSize()).header("X-Silverpeas-Size", (Object)allGroups.originalListSize()).build();
    }

    @GET
    @Path(value="application/{instanceId}")
    @Produces(value={"application/json"})
    public Response getGroupsInApplication(@PathParam(value="instanceId") String instanceId, @QueryParam(value="withChildren") boolean withChildren, @QueryParam(value="roles") String roles, @QueryParam(value="matchingAllRoles") boolean matchingAllRoles, @QueryParam(value="resource") String resource, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="domain") String domain, @QueryParam(value="userStatesToExclude") Set<UserState> userStatesToExclude) {
        UserGroupsSearchCriteriaBuilder criteriaBuilder;
        String domainId;
        String[] roleNames = StringUtil.isDefined((String)roles) ? roles.split(",") : new String[]{};
        String string = domainId = "-1".equals(domain) ? null : domain;
        if (this.getUser().isDomainRestricted()) {
            domainId = this.getUser().getDomainId();
            criteriaBuilder = UserGroupsSearchCriteriaBuilder.aSearchCriteria().withComponentInstanceId(instanceId).withRoles(roleNames, matchingAllRoles).withResourceId(resource).withDomainId(domainId).withMixedDomainId().withName(name).withPaginationPage(this.fromPage(page));
        } else {
            criteriaBuilder = UserGroupsSearchCriteriaBuilder.aSearchCriteria().withComponentInstanceId(instanceId).withRoles(roleNames, matchingAllRoles).withResourceId(resource).withDomainId(domainId).withName(name).withPaginationPage(this.fromPage(page));
        }
        if (withChildren) {
            criteriaBuilder.withChildren();
        }
        this.userStateFilter(criteriaBuilder, userStatesToExclude);
        SilverpeasList groups = this.getOrganisationController().searchGroups(criteriaBuilder.build(), true);
        URI groupsUri = this.getUri().getBaseUriBuilder().path("profile/groups").build(new Object[0]);
        return Response.ok((Object)this.asWebEntity((List<? extends Group>)groups, UserGroupProfileResource.locatedAt(groupsUri))).header(RESPONSE_HEADER_GROUPSIZE, (Object)groups.originalListSize()).header("X-Silverpeas-Size", (Object)groups.originalListSize()).build();
    }

    @GET
    @Path(value="{path: [0-9]+(/groups/[0-9]+)*}")
    @Produces(value={"application/json"})
    public UserGroupProfileEntity getGroup(@PathParam(value="path") String groupPath) {
        String[] groupIds = groupPath.split("/groups/");
        String groupId = groupIds[groupIds.length - 1];
        Group theGroup = this.profileService.getGroupAccessibleToUser(groupId, UserDetail.from((User)this.getUser()));
        return this.asWebEntity(theGroup, UserGroupProfileResource.identifiedBy(this.getUri().getAbsolutePath()));
    }

    @GET
    @Path(value="{path:[0-9]+/groups(/[0-9]+/groups)*}")
    @Produces(value={"application/json"})
    public Response getSubGroups(@PathParam(value="path") String groups, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="withChildren") boolean withChildren, @QueryParam(value="userStatesToExclude") Set<UserState> userStatesToExclude) {
        UserGroupsSearchCriteriaBuilder criteriaBuilder;
        String[] groupIds = groups.split("/groups/?");
        String groupId = groupIds[groupIds.length - 1];
        this.profileService.getGroupAccessibleToUser(groupId, UserDetail.from((User)this.getUser()));
        if (this.getUser().isDomainRestricted()) {
            String domainId = this.getUser().getDomainId();
            criteriaBuilder = UserGroupsSearchCriteriaBuilder.aSearchCriteria().withSuperGroupId(groupId).withDomainId(domainId).withMixedDomainId().withName(name).withPaginationPage(this.fromPage(page));
        } else {
            criteriaBuilder = UserGroupsSearchCriteriaBuilder.aSearchCriteria().withSuperGroupId(groupId).withName(name).withPaginationPage(this.fromPage(page));
        }
        if (withChildren) {
            criteriaBuilder.withChildren();
        }
        this.userStateFilter(criteriaBuilder, userStatesToExclude);
        SilverpeasList subgroups = this.getOrganisationController().searchGroups(criteriaBuilder.build(), true);
        return Response.ok((Object)this.asWebEntity((List<? extends Group>)subgroups, UserGroupProfileResource.locatedAt(this.getUri().getAbsolutePath()))).header(RESPONSE_HEADER_GROUPSIZE, (Object)subgroups.originalListSize()).header("X-Silverpeas-Size", (Object)subgroups.originalListSize()).build();
    }

    private void userStateFilter(UserGroupsSearchCriteriaBuilder criteriaBuilder, Set<UserState> userStatesToExclude) {
        HashSet<UserState> statesToExclude = new HashSet<UserState>();
        statesToExclude.add(UserState.REMOVED);
        if (CollectionUtil.isNotEmpty(userStatesToExclude)) {
            statesToExclude.addAll(userStatesToExclude);
        }
        criteriaBuilder.withUserStatesToExclude(statesToExclude.toArray(new UserState[0]));
    }

    protected String getResourceBasePath() {
        return "profile/groups";
    }

    public String getComponentId() {
        return null;
    }

    protected static URI locatedAt(URI uri) {
        return uri;
    }

    protected static URI identifiedBy(URI uri) {
        return uri;
    }

    private UserGroupProfileEntity[] asWebEntity(List<? extends Group> allGroups, URI baseUri) {
        return UserGroupProfileEntity.fromGroups(allGroups, baseUri);
    }

    private UserGroupProfileEntity asWebEntity(Group group, URI groupUri) {
        return UserGroupProfileEntity.fromGroup(group).withAsUri(groupUri);
    }

    public void validateUserAuthorization(UserPrivilegeValidation validation) {
        User currentUser = this.getUser();
        if (currentUser.isAccessGuest()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }
}

