/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.password;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.security.authentication.password.rule.PasswordRule;
import org.silverpeas.core.security.authentication.password.service.PasswordCheck;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.webapi.password.PasswordCheckEntity;
import org.silverpeas.core.webapi.password.PasswordRuleEntity;

public abstract class AbstractPasswordResource
extends RESTWebService {
    public String getComponentId() {
        return "";
    }

    protected PasswordRuleEntity asWebEntity(PasswordRule rule) {
        this.checkNotFoundStatus(rule);
        return PasswordRuleEntity.createFrom(rule, this.getLanguage());
    }

    protected PasswordCheckEntity asWebEntity(PasswordCheck check) {
        this.checkNotFoundStatus(check);
        return PasswordCheckEntity.createFrom(check);
    }

    private void checkNotFoundStatus(Object object) {
        if (object == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    protected String getLanguage() {
        String language = this.getUser() != null ? this.getUserPreferences().getLanguage() : (this.getHttpRequest().getLocale() != null ? DisplayI18NHelper.verifyLanguage((String)this.getHttpRequest().getLocale().getLanguage()) : DisplayI18NHelper.getDefaultLanguage());
        return language;
    }
}

