/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.subscription;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.web.subscription.SubscriptionResourcePath;

public class SubscriptionContext {
    private UserDetail user;
    private UserPreferences userPreferences;
    private InternalContext internalContext;

    public SubscriptionContext(UserDetail user, UserPreferences userPreferences) {
        this.user = user;
        this.userPreferences = userPreferences;
    }

    public SubscriptionContext initialize(SubscriptionResource resource) {
        this.internalContext = new InternalContext();
        this.internalContext.resource = resource;
        return this;
    }

    public SubscriptionContext atLocation(Location location) {
        this.internalContext.location = location;
        return this;
    }

    public SubscriptionContext withNodePath(Collection<NodeDetail> nodePath) {
        ArrayList<SubscriptionResourcePath> resourcePath = new ArrayList<SubscriptionResourcePath>(nodePath.size());
        for (NodeDetail node : nodePath) {
            resourcePath.add(new SubscriptionResourcePath(node.getName(this.userPreferences.getLanguage()), node.getLink()));
        }
        return this.withPath(resourcePath);
    }

    public SubscriptionContext withPath(Collection<SubscriptionResourcePath> path) {
        if (CollectionUtil.isNotEmpty(path)) {
            this.internalContext.path.addAll(path);
        }
        return this;
    }

    public UserDetail getUser() {
        return this.user;
    }

    public SubscriptionResource getResource() {
        return this.internalContext.resource;
    }

    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.internalContext.location);
    }

    public Collection<SubscriptionResourcePath> getPath() {
        return this.internalContext.path;
    }

    public String getDestinationUrl() {
        return this.internalContext.destinationUrl;
    }

    private static class InternalContext {
        String destinationUrl = "/RSubscription/jsp/Main";
        SubscriptionResource resource = null;
        Location location = null;
        Collection<SubscriptionResourcePath> path = new ArrayList<SubscriptionResourcePath>();

        private InternalContext() {
        }
    }
}

