/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletRegistryObject;
import com.sun.portal.portletcontainer.admin.registry.PortletRegistryTags;
import com.sun.portal.portletcontainer.admin.registry.PortletWindow;
import com.sun.portal.portletcontainer.admin.registry.XMLDocumentHelper;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PortletWindowRegistry
implements PortletRegistryTags,
PortletRegistryObject {
    private String version;
    private Map<String, PortletRegistryElement> portletWindowTable = new LinkedHashMap<String, PortletRegistryElement>();
    private List<PortletRegistryElement> portletWindowList = new ArrayList<PortletRegistryElement>();

    @Override
    public void read(Document document) throws PortletRegistryException {
        Element root = PortletRegistryHelper.getRootElement(document);
        if (root != null) {
            this.populate(root);
        }
    }

    @Override
    public void addRegistryElement(PortletRegistryElement portletWindow) {
        this.portletWindowTable.put(portletWindow.getName(), portletWindow);
        this.portletWindowList.add(portletWindow);
    }

    @Override
    public PortletRegistryElement getRegistryElement(String name) {
        return this.portletWindowTable.get(name);
    }

    @Override
    public List<PortletRegistryElement> getRegistryElements() {
        return this.portletWindowList;
    }

    @Override
    public boolean removeRegistryElement(PortletRegistryElement portletWindow) {
        this.portletWindowTable.remove(portletWindow.getName());
        return this.portletWindowList.remove(portletWindow);
    }

    private void populate(Element root) {
        Map<String, String> portletWindowRegistryAttributes = XMLDocumentHelper.createAttributeTable(root);
        this.setVersion(portletWindowRegistryAttributes.get("version"));
        List<Element> portletWindowTags = XMLDocumentHelper.createElementList(root);
        for (Element portletWindowTag : portletWindowTags) {
            PortletWindow portletWindow = new PortletWindow();
            portletWindow.populateValues(portletWindowTag);
            this.addRegistryElement(portletWindow);
        }
    }

    public String getVersion() {
        if (this.version == null) {
            return "1.0";
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void write(Document document) {
        Element rootTag = XMLDocumentHelper.createElement(document, "PortletWindowRegistry");
        rootTag.setAttribute("version", this.getVersion());
        document.appendChild(rootTag);
        int newRow = -1;
        for (PortletRegistryElement portletWindowElt : this.portletWindowTable.values()) {
            PortletWindow portletWindow = (PortletWindow)portletWindowElt;
            int row = portletWindow.getRow();
            if (row == -1) {
                portletWindow.setStringProperty("row", String.valueOf(++newRow));
            }
            if (row > newRow) {
                newRow = row;
            }
            if (portletWindow.getStringProperty("visible") == null) {
                portletWindow.setStringProperty("visible", "true");
            }
            if (portletWindow.getStringProperty("width") == null) {
                portletWindow.setStringProperty("width", "thick");
            }
            portletWindow.create(document, rootTag);
        }
    }
}

