/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.filter;

import edu.psu.swe.scim.server.filter.FilterBaseListener;
import edu.psu.swe.scim.server.filter.FilterParser;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.filter.AttributeComparisonExpression;
import edu.psu.swe.scim.spec.protocol.filter.AttributePresentExpression;
import edu.psu.swe.scim.spec.protocol.filter.CompareOperator;
import edu.psu.swe.scim.spec.protocol.filter.FilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.GroupExpression;
import edu.psu.swe.scim.spec.protocol.filter.LogicalExpression;
import edu.psu.swe.scim.spec.protocol.filter.LogicalOperator;
import edu.psu.swe.scim.spec.protocol.filter.ValuePathExpression;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionBuildingListener
extends FilterBaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionBuildingListener.class);
    protected Deque<FilterExpression> expressionStack = new ArrayDeque<FilterExpression>();

    @Override
    public void exitFilter(FilterParser.FilterContext ctx) {
        assert (this.expressionStack.size() == 1) : "wrong number (" + this.expressionStack.size() + ") of expressions on stack, should be 1";
    }

    @Override
    public void exitFilterGroupExpression(FilterParser.FilterGroupExpressionContext ctx) {
        boolean not = ctx.not != null;
        FilterExpression pop = this.expressionStack.pop();
        GroupExpression expression = new GroupExpression(not, pop);
        this.expressionStack.push(expression);
    }

    @Override
    public void exitFilterValuePathExpression(FilterParser.FilterValuePathExpressionContext ctx) {
        String attributePath = ctx.attributePath.getText();
        AttributeReference attributeReference = new AttributeReference(attributePath);
        String urn = attributeReference.getUrn();
        String parentAttributeName = attributeReference.getAttributeName();
        FilterExpression attributeExpression = this.expressionStack.pop();
        ValuePathExpression valuePathExpression = new ValuePathExpression(attributeReference, attributeExpression);
        attributeExpression.setAttributePath(urn, parentAttributeName);
        this.expressionStack.push(valuePathExpression);
    }

    @Override
    public void exitFilterAttributePresentExpression(FilterParser.FilterAttributePresentExpressionContext ctx) {
        String attributePathText = ctx.attributePath.getText();
        AttributeReference attributePath = new AttributeReference(attributePathText);
        AttributePresentExpression attributePresentExpression = new AttributePresentExpression(attributePath);
        this.expressionStack.push(attributePresentExpression);
    }

    @Override
    public void exitFilterAttributeCompareExpression(FilterParser.FilterAttributeCompareExpressionContext ctx) {
        String attributePathText = ctx.attributePath.getText();
        AttributeReference attributePath = new AttributeReference(attributePathText);
        CompareOperator compareOperator = CompareOperator.valueOf(ctx.op.getText().toUpperCase());
        String compareValueText = ctx.compareValue.getText();
        Object compareValue = ExpressionBuildingListener.parseJsonType(compareValueText);
        AttributeComparisonExpression attributeComparisonExpression = new AttributeComparisonExpression(attributePath, compareOperator, compareValue);
        this.expressionStack.push(attributeComparisonExpression);
    }

    @Override
    public void exitFilterLogicExpression(FilterParser.FilterLogicExpressionContext ctx) {
        String op = ctx.op.getText().toUpperCase();
        LogicalOperator logicalOperator = LogicalOperator.valueOf(op);
        FilterExpression right = this.expressionStack.pop();
        FilterExpression left = this.expressionStack.pop();
        LogicalExpression expression = new LogicalExpression(left, logicalOperator, right);
        this.expressionStack.push(expression);
    }

    @Override
    public void exitAttributeLogicExpression(FilterParser.AttributeLogicExpressionContext ctx) {
        String op = ctx.op.getText().toUpperCase();
        LogicalOperator logicalOperator = LogicalOperator.valueOf(op);
        FilterExpression right = this.expressionStack.pop();
        FilterExpression left = this.expressionStack.pop();
        LogicalExpression attributeLogicExpression = new LogicalExpression(left, logicalOperator, right);
        this.expressionStack.push(attributeLogicExpression);
    }

    @Override
    public void exitAttributeGroupExpression(FilterParser.AttributeGroupExpressionContext ctx) {
        boolean not = ctx.not != null;
        FilterExpression attributeExpression = this.expressionStack.pop();
        GroupExpression attributeGroupExpression = new GroupExpression(not, attributeExpression);
        this.expressionStack.push(attributeGroupExpression);
    }

    @Override
    public void exitAttributeCompareExpression(FilterParser.AttributeCompareExpressionContext ctx) {
        String attributeName = ctx.attributeName.getText();
        CompareOperator compareOperator = CompareOperator.valueOf(ctx.op.getText().toUpperCase());
        Object value = ExpressionBuildingListener.parseJsonType(ctx.compareValue.getText());
        AttributeReference attributeReference = new AttributeReference(attributeName);
        AttributeComparisonExpression expression = new AttributeComparisonExpression(attributeReference, compareOperator, value);
        this.expressionStack.push(expression);
    }

    @Override
    public void exitAttributePresentExpression(FilterParser.AttributePresentExpressionContext ctx) {
        String attributeName = ctx.attributeName.getText();
        AttributeReference attributeReference = new AttributeReference(attributeName);
        AttributePresentExpression attributePresentExpression = new AttributePresentExpression(attributeReference);
        this.expressionStack.push(attributePresentExpression);
    }

    public FilterExpression getFilterExpression() {
        return this.expressionStack.peek();
    }

    private static Object parseJsonType(String jsonValue) {
        if (jsonValue.startsWith("\"")) {
            String doubleEscaped = jsonValue.substring(1, jsonValue.length() - 1).replaceAll("\\\\/", "\\\\\\\\/").replaceAll("\\\\'", "\\\\\\\\'");
            return StringEscapeUtils.unescapeEcmaScript((String)doubleEscaped);
        }
        if ("null".equals(jsonValue)) {
            return null;
        }
        if ("true".equals(jsonValue)) {
            return true;
        }
        if ("false".equals(jsonValue)) {
            return false;
        }
        try {
            return Double.parseDouble(jsonValue);
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse a json number: " + jsonValue);
            throw new IllegalStateException("Unable to parse JSON Value");
        }
    }
}

