/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import org.springframework.social.linkedin.api.PersonActivity;
import org.springframework.social.linkedin.api.UrlResource;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class UpdateContentPersonActivityMixin
extends LinkedInObjectMixin {
    @JsonProperty(value="personActivities")
    @JsonDeserialize(using=PersonActivitiesListDeserializer.class)
    List<PersonActivity> personActivities;

    @JsonCreator
    UpdateContentPersonActivityMixin(@JsonProperty(value="id") String id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="headline") String headline, @JsonProperty(value="industry") String industry, @JsonProperty(value="publicProfileUrl") String publicProfileUrl, @JsonProperty(value="siteStandardProfileRequest") UrlResource siteStandardProfileRequest, @JsonProperty(value="pictureUrl") String profilePictureUrl) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PersonActivitiesListDeserializer
    extends JsonDeserializer<List<PersonActivity>> {
        private PersonActivitiesListDeserializer() {
        }

        public List<PersonActivity> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new LinkedInModule());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken()) {
                JsonNode dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values");
                return (List)mapper.reader((TypeReference)new TypeReference<List<PersonActivity>>(){}).readValue(dataNode);
            }
            return null;
        }
    }
}

